<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MemberBase StructType
 * @subpackage Structs
 */
abstract class MemberBase extends AbstractStructBase
{
    /**
     * The UniqueDirectorId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $UniqueDirectorId;
    /**
     * The AppointmentDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $AppointmentDate;
    /**
     * The ResignationDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $ResignationDate;
    /**
     * The MemberSizePercentage
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $MemberSizePercentage;
    /**
     * The MemberContribution
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $MemberContribution;
    /**
     * The CountryOfOrigin
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CipcLookup
     */
    public $CountryOfOrigin;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CipcLookup
     */
    public $Status;
    /**
     * The PostalAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\BasicAddress
     */
    public $PostalAddress;
    /**
     * The ResidentialAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\BasicAddress
     */
    public $ResidentialAddress;
    /**
     * The DirectorType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CipcLookup
     */
    public $DirectorType;
    /**
     * The CountryOfResidence
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CipcLookup
     */
    public $CountryOfResidence;
    /**
     * Constructor method for MemberBase
     * @uses MemberBase::setUniqueDirectorId()
     * @uses MemberBase::setAppointmentDate()
     * @uses MemberBase::setResignationDate()
     * @uses MemberBase::setMemberSizePercentage()
     * @uses MemberBase::setMemberContribution()
     * @uses MemberBase::setCountryOfOrigin()
     * @uses MemberBase::setStatus()
     * @uses MemberBase::setPostalAddress()
     * @uses MemberBase::setResidentialAddress()
     * @uses MemberBase::setDirectorType()
     * @uses MemberBase::setCountryOfResidence()
     * @param int $uniqueDirectorId
     * @param string $appointmentDate
     * @param string $resignationDate
     * @param float $memberSizePercentage
     * @param float $memberContribution
     * @param \StructType\CipcLookup $countryOfOrigin
     * @param \StructType\CipcLookup $status
     * @param \StructType\BasicAddress $postalAddress
     * @param \StructType\BasicAddress $residentialAddress
     * @param \StructType\CipcLookup $directorType
     * @param \StructType\CipcLookup $countryOfResidence
     */
    public function __construct($uniqueDirectorId = null, $appointmentDate = null, $resignationDate = null, $memberSizePercentage = null, $memberContribution = null, \StructType\CipcLookup $countryOfOrigin = null, \StructType\CipcLookup $status = null, \StructType\BasicAddress $postalAddress = null, \StructType\BasicAddress $residentialAddress = null, \StructType\CipcLookup $directorType = null, \StructType\CipcLookup $countryOfResidence = null)
    {
        $this
            ->setUniqueDirectorId($uniqueDirectorId)
            ->setAppointmentDate($appointmentDate)
            ->setResignationDate($resignationDate)
            ->setMemberSizePercentage($memberSizePercentage)
            ->setMemberContribution($memberContribution)
            ->setCountryOfOrigin($countryOfOrigin)
            ->setStatus($status)
            ->setPostalAddress($postalAddress)
            ->setResidentialAddress($residentialAddress)
            ->setDirectorType($directorType)
            ->setCountryOfResidence($countryOfResidence);
    }
    /**
     * Get UniqueDirectorId value
     * @return int
     */
    public function getUniqueDirectorId()
    {
        return $this->UniqueDirectorId;
    }
    /**
     * Set UniqueDirectorId value
     * @param int $uniqueDirectorId
     * @return \StructType\MemberBase
     */
    public function setUniqueDirectorId($uniqueDirectorId = null)
    {
        // validation for constraint: int
        if (!is_null($uniqueDirectorId) && !is_numeric($uniqueDirectorId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($uniqueDirectorId)), __LINE__);
        }
        $this->UniqueDirectorId = $uniqueDirectorId;
        return $this;
    }
    /**
     * Get AppointmentDate value
     * @return string
     */
    public function getAppointmentDate()
    {
        return $this->AppointmentDate;
    }
    /**
     * Set AppointmentDate value
     * @param string $appointmentDate
     * @return \StructType\MemberBase
     */
    public function setAppointmentDate($appointmentDate = null)
    {
        // validation for constraint: string
        if (!is_null($appointmentDate) && !is_string($appointmentDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($appointmentDate)), __LINE__);
        }
        $this->AppointmentDate = $appointmentDate;
        return $this;
    }
    /**
     * Get ResignationDate value
     * @return string
     */
    public function getResignationDate()
    {
        return $this->ResignationDate;
    }
    /**
     * Set ResignationDate value
     * @param string $resignationDate
     * @return \StructType\MemberBase
     */
    public function setResignationDate($resignationDate = null)
    {
        // validation for constraint: string
        if (!is_null($resignationDate) && !is_string($resignationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($resignationDate)), __LINE__);
        }
        $this->ResignationDate = $resignationDate;
        return $this;
    }
    /**
     * Get MemberSizePercentage value
     * @return float
     */
    public function getMemberSizePercentage()
    {
        return $this->MemberSizePercentage;
    }
    /**
     * Set MemberSizePercentage value
     * @param float $memberSizePercentage
     * @return \StructType\MemberBase
     */
    public function setMemberSizePercentage($memberSizePercentage = null)
    {
        $this->MemberSizePercentage = $memberSizePercentage;
        return $this;
    }
    /**
     * Get MemberContribution value
     * @return float
     */
    public function getMemberContribution()
    {
        return $this->MemberContribution;
    }
    /**
     * Set MemberContribution value
     * @param float $memberContribution
     * @return \StructType\MemberBase
     */
    public function setMemberContribution($memberContribution = null)
    {
        $this->MemberContribution = $memberContribution;
        return $this;
    }
    /**
     * Get CountryOfOrigin value
     * @return \StructType\CipcLookup|null
     */
    public function getCountryOfOrigin()
    {
        return $this->CountryOfOrigin;
    }
    /**
     * Set CountryOfOrigin value
     * @param \StructType\CipcLookup $countryOfOrigin
     * @return \StructType\MemberBase
     */
    public function setCountryOfOrigin(\StructType\CipcLookup $countryOfOrigin = null)
    {
        $this->CountryOfOrigin = $countryOfOrigin;
        return $this;
    }
    /**
     * Get Status value
     * @return \StructType\CipcLookup|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param \StructType\CipcLookup $status
     * @return \StructType\MemberBase
     */
    public function setStatus(\StructType\CipcLookup $status = null)
    {
        $this->Status = $status;
        return $this;
    }
    /**
     * Get PostalAddress value
     * @return \StructType\BasicAddress|null
     */
    public function getPostalAddress()
    {
        return $this->PostalAddress;
    }
    /**
     * Set PostalAddress value
     * @param \StructType\BasicAddress $postalAddress
     * @return \StructType\MemberBase
     */
    public function setPostalAddress(\StructType\BasicAddress $postalAddress = null)
    {
        $this->PostalAddress = $postalAddress;
        return $this;
    }
    /**
     * Get ResidentialAddress value
     * @return \StructType\BasicAddress|null
     */
    public function getResidentialAddress()
    {
        return $this->ResidentialAddress;
    }
    /**
     * Set ResidentialAddress value
     * @param \StructType\BasicAddress $residentialAddress
     * @return \StructType\MemberBase
     */
    public function setResidentialAddress(\StructType\BasicAddress $residentialAddress = null)
    {
        $this->ResidentialAddress = $residentialAddress;
        return $this;
    }
    /**
     * Get DirectorType value
     * @return \StructType\CipcLookup|null
     */
    public function getDirectorType()
    {
        return $this->DirectorType;
    }
    /**
     * Set DirectorType value
     * @param \StructType\CipcLookup $directorType
     * @return \StructType\MemberBase
     */
    public function setDirectorType(\StructType\CipcLookup $directorType = null)
    {
        $this->DirectorType = $directorType;
        return $this;
    }
    /**
     * Get CountryOfResidence value
     * @return \StructType\CipcLookup|null
     */
    public function getCountryOfResidence()
    {
        return $this->CountryOfResidence;
    }
    /**
     * Set CountryOfResidence value
     * @param \StructType\CipcLookup $countryOfResidence
     * @return \StructType\MemberBase
     */
    public function setCountryOfResidence(\StructType\CipcLookup $countryOfResidence = null)
    {
        $this->CountryOfResidence = $countryOfResidence;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MemberBase
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
