<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for History StructType
 * @subpackage Structs
 */
class History extends AbstractStructBase
{
    /**
     * The EffectiveDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $EffectiveDate;
    /**
     * The ChangeType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CipcLookup
     */
    public $ChangeType;
    /**
     * The Memo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Memo;
    /**
     * Constructor method for History
     * @uses History::setEffectiveDate()
     * @uses History::setChangeType()
     * @uses History::setMemo()
     * @param string $effectiveDate
     * @param \StructType\CipcLookup $changeType
     * @param string $memo
     */
    public function __construct($effectiveDate = null, \StructType\CipcLookup $changeType = null, $memo = null)
    {
        $this
            ->setEffectiveDate($effectiveDate)
            ->setChangeType($changeType)
            ->setMemo($memo);
    }
    /**
     * Get EffectiveDate value
     * @return string
     */
    public function getEffectiveDate()
    {
        return $this->EffectiveDate;
    }
    /**
     * Set EffectiveDate value
     * @param string $effectiveDate
     * @return \StructType\History
     */
    public function setEffectiveDate($effectiveDate = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveDate) && !is_string($effectiveDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($effectiveDate)), __LINE__);
        }
        $this->EffectiveDate = $effectiveDate;
        return $this;
    }
    /**
     * Get ChangeType value
     * @return \StructType\CipcLookup|null
     */
    public function getChangeType()
    {
        return $this->ChangeType;
    }
    /**
     * Set ChangeType value
     * @param \StructType\CipcLookup $changeType
     * @return \StructType\History
     */
    public function setChangeType(\StructType\CipcLookup $changeType = null)
    {
        $this->ChangeType = $changeType;
        return $this;
    }
    /**
     * Get Memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->Memo;
    }
    /**
     * Set Memo value
     * @param string $memo
     * @return \StructType\History
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($memo)), __LINE__);
        }
        $this->Memo = $memo;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\History
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
