<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Financials StructType
 * @subpackage Structs
 */
class Financials extends AbstractStructBase
{
    /**
     * The FinancialYearEnd
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $FinancialYearEnd;
    /**
     * The FinEffectiveDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $FinEffectiveDate;
    /**
     * The IssuedShares
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $IssuedShares;
    /**
     * The IssuedCapital
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $IssuedCapital;
    /**
     * The AuthorizedShares
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $AuthorizedShares;
    /**
     * The AuthorizedCapital
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $AuthorizedCapital;
    /**
     * The TaxNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TaxNumber;
    /**
     * Constructor method for Financials
     * @uses Financials::setFinancialYearEnd()
     * @uses Financials::setFinEffectiveDate()
     * @uses Financials::setIssuedShares()
     * @uses Financials::setIssuedCapital()
     * @uses Financials::setAuthorizedShares()
     * @uses Financials::setAuthorizedCapital()
     * @uses Financials::setTaxNumber()
     * @param int $financialYearEnd
     * @param string $finEffectiveDate
     * @param int $issuedShares
     * @param float $issuedCapital
     * @param int $authorizedShares
     * @param float $authorizedCapital
     * @param string $taxNumber
     */
    public function __construct($financialYearEnd = null, $finEffectiveDate = null, $issuedShares = null, $issuedCapital = null, $authorizedShares = null, $authorizedCapital = null, $taxNumber = null)
    {
        $this
            ->setFinancialYearEnd($financialYearEnd)
            ->setFinEffectiveDate($finEffectiveDate)
            ->setIssuedShares($issuedShares)
            ->setIssuedCapital($issuedCapital)
            ->setAuthorizedShares($authorizedShares)
            ->setAuthorizedCapital($authorizedCapital)
            ->setTaxNumber($taxNumber);
    }
    /**
     * Get FinancialYearEnd value
     * @return int
     */
    public function getFinancialYearEnd()
    {
        return $this->FinancialYearEnd;
    }
    /**
     * Set FinancialYearEnd value
     * @param int $financialYearEnd
     * @return \StructType\Financials
     */
    public function setFinancialYearEnd($financialYearEnd = null)
    {
        // validation for constraint: int
        if (!is_null($financialYearEnd) && !is_numeric($financialYearEnd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($financialYearEnd)), __LINE__);
        }
        $this->FinancialYearEnd = $financialYearEnd;
        return $this;
    }
    /**
     * Get FinEffectiveDate value
     * @return string
     */
    public function getFinEffectiveDate()
    {
        return $this->FinEffectiveDate;
    }
    /**
     * Set FinEffectiveDate value
     * @param string $finEffectiveDate
     * @return \StructType\Financials
     */
    public function setFinEffectiveDate($finEffectiveDate = null)
    {
        // validation for constraint: string
        if (!is_null($finEffectiveDate) && !is_string($finEffectiveDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($finEffectiveDate)), __LINE__);
        }
        $this->FinEffectiveDate = $finEffectiveDate;
        return $this;
    }
    /**
     * Get IssuedShares value
     * @return int
     */
    public function getIssuedShares()
    {
        return $this->IssuedShares;
    }
    /**
     * Set IssuedShares value
     * @param int $issuedShares
     * @return \StructType\Financials
     */
    public function setIssuedShares($issuedShares = null)
    {
        // validation for constraint: int
        if (!is_null($issuedShares) && !is_numeric($issuedShares)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($issuedShares)), __LINE__);
        }
        $this->IssuedShares = $issuedShares;
        return $this;
    }
    /**
     * Get IssuedCapital value
     * @return float
     */
    public function getIssuedCapital()
    {
        return $this->IssuedCapital;
    }
    /**
     * Set IssuedCapital value
     * @param float $issuedCapital
     * @return \StructType\Financials
     */
    public function setIssuedCapital($issuedCapital = null)
    {
        $this->IssuedCapital = $issuedCapital;
        return $this;
    }
    /**
     * Get AuthorizedShares value
     * @return int
     */
    public function getAuthorizedShares()
    {
        return $this->AuthorizedShares;
    }
    /**
     * Set AuthorizedShares value
     * @param int $authorizedShares
     * @return \StructType\Financials
     */
    public function setAuthorizedShares($authorizedShares = null)
    {
        // validation for constraint: int
        if (!is_null($authorizedShares) && !is_numeric($authorizedShares)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($authorizedShares)), __LINE__);
        }
        $this->AuthorizedShares = $authorizedShares;
        return $this;
    }
    /**
     * Get AuthorizedCapital value
     * @return float
     */
    public function getAuthorizedCapital()
    {
        return $this->AuthorizedCapital;
    }
    /**
     * Set AuthorizedCapital value
     * @param float $authorizedCapital
     * @return \StructType\Financials
     */
    public function setAuthorizedCapital($authorizedCapital = null)
    {
        $this->AuthorizedCapital = $authorizedCapital;
        return $this;
    }
    /**
     * Get TaxNumber value
     * @return string|null
     */
    public function getTaxNumber()
    {
        return $this->TaxNumber;
    }
    /**
     * Set TaxNumber value
     * @param string $taxNumber
     * @return \StructType\Financials
     */
    public function setTaxNumber($taxNumber = null)
    {
        // validation for constraint: string
        if (!is_null($taxNumber) && !is_string($taxNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($taxNumber)), __LINE__);
        }
        $this->TaxNumber = $taxNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Financials
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
