<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CompanyReport StructType
 * @subpackage Structs
 */
class CompanyReport extends AbstractStructBase
{
    /**
     * The CompanyInformation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CompanyInformation
     */
    public $CompanyInformation;
    /**
     * The Financials
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Financials
     */
    public $Financials;
    /**
     * The Members
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfMemberBase
     */
    public $Members;
    /**
     * The Auditors
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfAuditor
     */
    public $Auditors;
    /**
     * The CapitalInformation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfCapital
     */
    public $CapitalInformation;
    /**
     * The HistoryInformation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfHistory
     */
    public $HistoryInformation;
    /**
     * Constructor method for CompanyReport
     * @uses CompanyReport::setCompanyInformation()
     * @uses CompanyReport::setFinancials()
     * @uses CompanyReport::setMembers()
     * @uses CompanyReport::setAuditors()
     * @uses CompanyReport::setCapitalInformation()
     * @uses CompanyReport::setHistoryInformation()
     * @param \StructType\CompanyInformation $companyInformation
     * @param \StructType\Financials $financials
     * @param \ArrayType\ArrayOfMemberBase $members
     * @param \ArrayType\ArrayOfAuditor $auditors
     * @param \ArrayType\ArrayOfCapital $capitalInformation
     * @param \ArrayType\ArrayOfHistory $historyInformation
     */
    public function __construct(\StructType\CompanyInformation $companyInformation = null, \StructType\Financials $financials = null, \ArrayType\ArrayOfMemberBase $members = null, \ArrayType\ArrayOfAuditor $auditors = null, \ArrayType\ArrayOfCapital $capitalInformation = null, \ArrayType\ArrayOfHistory $historyInformation = null)
    {
        $this
            ->setCompanyInformation($companyInformation)
            ->setFinancials($financials)
            ->setMembers($members)
            ->setAuditors($auditors)
            ->setCapitalInformation($capitalInformation)
            ->setHistoryInformation($historyInformation);
    }
    /**
     * Get CompanyInformation value
     * @return \StructType\CompanyInformation|null
     */
    public function getCompanyInformation()
    {
        return $this->CompanyInformation;
    }
    /**
     * Set CompanyInformation value
     * @param \StructType\CompanyInformation $companyInformation
     * @return \StructType\CompanyReport
     */
    public function setCompanyInformation(\StructType\CompanyInformation $companyInformation = null)
    {
        $this->CompanyInformation = $companyInformation;
        return $this;
    }
    /**
     * Get Financials value
     * @return \StructType\Financials|null
     */
    public function getFinancials()
    {
        return $this->Financials;
    }
    /**
     * Set Financials value
     * @param \StructType\Financials $financials
     * @return \StructType\CompanyReport
     */
    public function setFinancials(\StructType\Financials $financials = null)
    {
        $this->Financials = $financials;
        return $this;
    }
    /**
     * Get Members value
     * @return \ArrayType\ArrayOfMemberBase|null
     */
    public function getMembers()
    {
        return $this->Members;
    }
    /**
     * Set Members value
     * @param \ArrayType\ArrayOfMemberBase $members
     * @return \StructType\CompanyReport
     */
    public function setMembers(\ArrayType\ArrayOfMemberBase $members = null)
    {
        $this->Members = $members;
        return $this;
    }
    /**
     * Get Auditors value
     * @return \ArrayType\ArrayOfAuditor|null
     */
    public function getAuditors()
    {
        return $this->Auditors;
    }
    /**
     * Set Auditors value
     * @param \ArrayType\ArrayOfAuditor $auditors
     * @return \StructType\CompanyReport
     */
    public function setAuditors(\ArrayType\ArrayOfAuditor $auditors = null)
    {
        $this->Auditors = $auditors;
        return $this;
    }
    /**
     * Get CapitalInformation value
     * @return \ArrayType\ArrayOfCapital|null
     */
    public function getCapitalInformation()
    {
        return $this->CapitalInformation;
    }
    /**
     * Set CapitalInformation value
     * @param \ArrayType\ArrayOfCapital $capitalInformation
     * @return \StructType\CompanyReport
     */
    public function setCapitalInformation(\ArrayType\ArrayOfCapital $capitalInformation = null)
    {
        $this->CapitalInformation = $capitalInformation;
        return $this;
    }
    /**
     * Get HistoryInformation value
     * @return \ArrayType\ArrayOfHistory|null
     */
    public function getHistoryInformation()
    {
        return $this->HistoryInformation;
    }
    /**
     * Set HistoryInformation value
     * @param \ArrayType\ArrayOfHistory $historyInformation
     * @return \StructType\CompanyReport
     */
    public function setHistoryInformation(\ArrayType\ArrayOfHistory $historyInformation = null)
    {
        $this->HistoryInformation = $historyInformation;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CompanyReport
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
