<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CipcUberSearchRequest StructType
 * @subpackage Structs
 */
class CipcUberSearchRequest extends AbstractStructBase
{
    /**
     * The RequestType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $RequestType;
    /**
     * The ParentBillSearchId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $ParentBillSearchId;
    /**
     * The Request
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\RequestBase
     */
    public $Request;
    /**
     * The ParentRequest
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\RequestBase
     */
    public $ParentRequest;
    /**
     * Constructor method for CipcUberSearchRequest
     * @uses CipcUberSearchRequest::setRequestType()
     * @uses CipcUberSearchRequest::setParentBillSearchId()
     * @uses CipcUberSearchRequest::setRequest()
     * @uses CipcUberSearchRequest::setParentRequest()
     * @param string $requestType
     * @param int $parentBillSearchId
     * @param \StructType\RequestBase $request
     * @param \StructType\RequestBase $parentRequest
     */
    public function __construct($requestType = null, $parentBillSearchId = null, \StructType\RequestBase $request = null, \StructType\RequestBase $parentRequest = null)
    {
        $this
            ->setRequestType($requestType)
            ->setParentBillSearchId($parentBillSearchId)
            ->setRequest($request)
            ->setParentRequest($parentRequest);
    }
    /**
     * Get RequestType value
     * @return string
     */
    public function getRequestType()
    {
        return $this->RequestType;
    }
    /**
     * Set RequestType value
     * @uses \EnumType\RequestType::valueIsValid()
     * @uses \EnumType\RequestType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $requestType
     * @return \StructType\CipcUberSearchRequest
     */
    public function setRequestType($requestType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\RequestType::valueIsValid($requestType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $requestType, implode(', ', \EnumType\RequestType::getValidValues())), __LINE__);
        }
        $this->RequestType = $requestType;
        return $this;
    }
    /**
     * Get ParentBillSearchId value
     * @return int
     */
    public function getParentBillSearchId()
    {
        return $this->ParentBillSearchId;
    }
    /**
     * Set ParentBillSearchId value
     * @param int $parentBillSearchId
     * @return \StructType\CipcUberSearchRequest
     */
    public function setParentBillSearchId($parentBillSearchId = null)
    {
        // validation for constraint: int
        if (!is_null($parentBillSearchId) && !is_numeric($parentBillSearchId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($parentBillSearchId)), __LINE__);
        }
        $this->ParentBillSearchId = $parentBillSearchId;
        return $this;
    }
    /**
     * Get Request value
     * @return \StructType\RequestBase|null
     */
    public function getRequest()
    {
        return $this->Request;
    }
    /**
     * Set Request value
     * @param \StructType\RequestBase $request
     * @return \StructType\CipcUberSearchRequest
     */
    public function setRequest(\StructType\RequestBase $request = null)
    {
        $this->Request = $request;
        return $this;
    }
    /**
     * Get ParentRequest value
     * @return \StructType\RequestBase|null
     */
    public function getParentRequest()
    {
        return $this->ParentRequest;
    }
    /**
     * Set ParentRequest value
     * @param \StructType\RequestBase $parentRequest
     * @return \StructType\CipcUberSearchRequest
     */
    public function setParentRequest(\StructType\RequestBase $parentRequest = null)
    {
        $this->ParentRequest = $parentRequest;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CipcUberSearchRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
