<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AuditorProfession StructType
 * @subpackage Structs
 */
class AuditorProfession extends CipcLookup
{
    /**
     * The ProfessionNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ProfessionNumber;
    /**
     * Constructor method for AuditorProfession
     * @uses AuditorProfession::setProfessionNumber()
     * @param string $professionNumber
     */
    public function __construct($professionNumber = null)
    {
        $this
            ->setProfessionNumber($professionNumber);
    }
    /**
     * Get ProfessionNumber value
     * @return string|null
     */
    public function getProfessionNumber()
    {
        return $this->ProfessionNumber;
    }
    /**
     * Set ProfessionNumber value
     * @param string $professionNumber
     * @return \StructType\AuditorProfession
     */
    public function setProfessionNumber($professionNumber = null)
    {
        // validation for constraint: string
        if (!is_null($professionNumber) && !is_string($professionNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($professionNumber)), __LINE__);
        }
        $this->ProfessionNumber = $professionNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AuditorProfession
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
