<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Auditor StructType
 * @subpackage Structs
 */
class Auditor extends AbstractStructBase
{
    /**
     * The StartDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $StartDate;
    /**
     * The EndDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $EndDate;
    /**
     * The ExpiryDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $ExpiryDate;
    /**
     * The RegistrationEntryDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $RegistrationEntryDate;
    /**
     * The DateOnForm
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $DateOnForm;
    /**
     * The FormDateRecieved
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $FormDateRecieved;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Profession
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AuditorProfession
     */
    public $Profession;
    /**
     * The ReferenceNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReferenceNumber;
    /**
     * The FineLetter
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FineLetter;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CipcLookup
     */
    public $Status;
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CipcLookup
     */
    public $Type;
    /**
     * The PostalAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\BasicAddress
     */
    public $PostalAddress;
    /**
     * The ResidentialAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\BasicAddress
     */
    public $ResidentialAddress;
    /**
     * Constructor method for Auditor
     * @uses Auditor::setStartDate()
     * @uses Auditor::setEndDate()
     * @uses Auditor::setExpiryDate()
     * @uses Auditor::setRegistrationEntryDate()
     * @uses Auditor::setDateOnForm()
     * @uses Auditor::setFormDateRecieved()
     * @uses Auditor::setName()
     * @uses Auditor::setProfession()
     * @uses Auditor::setReferenceNumber()
     * @uses Auditor::setFineLetter()
     * @uses Auditor::setStatus()
     * @uses Auditor::setType()
     * @uses Auditor::setPostalAddress()
     * @uses Auditor::setResidentialAddress()
     * @param string $startDate
     * @param string $endDate
     * @param string $expiryDate
     * @param string $registrationEntryDate
     * @param string $dateOnForm
     * @param string $formDateRecieved
     * @param string $name
     * @param \StructType\AuditorProfession $profession
     * @param string $referenceNumber
     * @param string $fineLetter
     * @param \StructType\CipcLookup $status
     * @param \StructType\CipcLookup $type
     * @param \StructType\BasicAddress $postalAddress
     * @param \StructType\BasicAddress $residentialAddress
     */
    public function __construct($startDate = null, $endDate = null, $expiryDate = null, $registrationEntryDate = null, $dateOnForm = null, $formDateRecieved = null, $name = null, \StructType\AuditorProfession $profession = null, $referenceNumber = null, $fineLetter = null, \StructType\CipcLookup $status = null, \StructType\CipcLookup $type = null, \StructType\BasicAddress $postalAddress = null, \StructType\BasicAddress $residentialAddress = null)
    {
        $this
            ->setStartDate($startDate)
            ->setEndDate($endDate)
            ->setExpiryDate($expiryDate)
            ->setRegistrationEntryDate($registrationEntryDate)
            ->setDateOnForm($dateOnForm)
            ->setFormDateRecieved($formDateRecieved)
            ->setName($name)
            ->setProfession($profession)
            ->setReferenceNumber($referenceNumber)
            ->setFineLetter($fineLetter)
            ->setStatus($status)
            ->setType($type)
            ->setPostalAddress($postalAddress)
            ->setResidentialAddress($residentialAddress);
    }
    /**
     * Get StartDate value
     * @return string
     */
    public function getStartDate()
    {
        return $this->StartDate;
    }
    /**
     * Set StartDate value
     * @param string $startDate
     * @return \StructType\Auditor
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($startDate)), __LINE__);
        }
        $this->StartDate = $startDate;
        return $this;
    }
    /**
     * Get EndDate value
     * @return string
     */
    public function getEndDate()
    {
        return $this->EndDate;
    }
    /**
     * Set EndDate value
     * @param string $endDate
     * @return \StructType\Auditor
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($endDate)), __LINE__);
        }
        $this->EndDate = $endDate;
        return $this;
    }
    /**
     * Get ExpiryDate value
     * @return string
     */
    public function getExpiryDate()
    {
        return $this->ExpiryDate;
    }
    /**
     * Set ExpiryDate value
     * @param string $expiryDate
     * @return \StructType\Auditor
     */
    public function setExpiryDate($expiryDate = null)
    {
        // validation for constraint: string
        if (!is_null($expiryDate) && !is_string($expiryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($expiryDate)), __LINE__);
        }
        $this->ExpiryDate = $expiryDate;
        return $this;
    }
    /**
     * Get RegistrationEntryDate value
     * @return string
     */
    public function getRegistrationEntryDate()
    {
        return $this->RegistrationEntryDate;
    }
    /**
     * Set RegistrationEntryDate value
     * @param string $registrationEntryDate
     * @return \StructType\Auditor
     */
    public function setRegistrationEntryDate($registrationEntryDate = null)
    {
        // validation for constraint: string
        if (!is_null($registrationEntryDate) && !is_string($registrationEntryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($registrationEntryDate)), __LINE__);
        }
        $this->RegistrationEntryDate = $registrationEntryDate;
        return $this;
    }
    /**
     * Get DateOnForm value
     * @return string
     */
    public function getDateOnForm()
    {
        return $this->DateOnForm;
    }
    /**
     * Set DateOnForm value
     * @param string $dateOnForm
     * @return \StructType\Auditor
     */
    public function setDateOnForm($dateOnForm = null)
    {
        // validation for constraint: string
        if (!is_null($dateOnForm) && !is_string($dateOnForm)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateOnForm)), __LINE__);
        }
        $this->DateOnForm = $dateOnForm;
        return $this;
    }
    /**
     * Get FormDateRecieved value
     * @return string
     */
    public function getFormDateRecieved()
    {
        return $this->FormDateRecieved;
    }
    /**
     * Set FormDateRecieved value
     * @param string $formDateRecieved
     * @return \StructType\Auditor
     */
    public function setFormDateRecieved($formDateRecieved = null)
    {
        // validation for constraint: string
        if (!is_null($formDateRecieved) && !is_string($formDateRecieved)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($formDateRecieved)), __LINE__);
        }
        $this->FormDateRecieved = $formDateRecieved;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\Auditor
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Profession value
     * @return \StructType\AuditorProfession|null
     */
    public function getProfession()
    {
        return $this->Profession;
    }
    /**
     * Set Profession value
     * @param \StructType\AuditorProfession $profession
     * @return \StructType\Auditor
     */
    public function setProfession(\StructType\AuditorProfession $profession = null)
    {
        $this->Profession = $profession;
        return $this;
    }
    /**
     * Get ReferenceNumber value
     * @return string|null
     */
    public function getReferenceNumber()
    {
        return $this->ReferenceNumber;
    }
    /**
     * Set ReferenceNumber value
     * @param string $referenceNumber
     * @return \StructType\Auditor
     */
    public function setReferenceNumber($referenceNumber = null)
    {
        // validation for constraint: string
        if (!is_null($referenceNumber) && !is_string($referenceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($referenceNumber)), __LINE__);
        }
        $this->ReferenceNumber = $referenceNumber;
        return $this;
    }
    /**
     * Get FineLetter value
     * @return string|null
     */
    public function getFineLetter()
    {
        return $this->FineLetter;
    }
    /**
     * Set FineLetter value
     * @param string $fineLetter
     * @return \StructType\Auditor
     */
    public function setFineLetter($fineLetter = null)
    {
        // validation for constraint: string
        if (!is_null($fineLetter) && !is_string($fineLetter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fineLetter)), __LINE__);
        }
        $this->FineLetter = $fineLetter;
        return $this;
    }
    /**
     * Get Status value
     * @return \StructType\CipcLookup|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param \StructType\CipcLookup $status
     * @return \StructType\Auditor
     */
    public function setStatus(\StructType\CipcLookup $status = null)
    {
        $this->Status = $status;
        return $this;
    }
    /**
     * Get Type value
     * @return \StructType\CipcLookup|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param \StructType\CipcLookup $type
     * @return \StructType\Auditor
     */
    public function setType(\StructType\CipcLookup $type = null)
    {
        $this->Type = $type;
        return $this;
    }
    /**
     * Get PostalAddress value
     * @return \StructType\BasicAddress|null
     */
    public function getPostalAddress()
    {
        return $this->PostalAddress;
    }
    /**
     * Set PostalAddress value
     * @param \StructType\BasicAddress $postalAddress
     * @return \StructType\Auditor
     */
    public function setPostalAddress(\StructType\BasicAddress $postalAddress = null)
    {
        $this->PostalAddress = $postalAddress;
        return $this;
    }
    /**
     * Get ResidentialAddress value
     * @return \StructType\BasicAddress|null
     */
    public function getResidentialAddress()
    {
        return $this->ResidentialAddress;
    }
    /**
     * Set ResidentialAddress value
     * @param \StructType\BasicAddress $residentialAddress
     * @return \StructType\Auditor
     */
    public function setResidentialAddress(\StructType\BasicAddress $residentialAddress = null)
    {
        $this->ResidentialAddress = $residentialAddress;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Auditor
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
