<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Retrieve ServiceType
 * @subpackage Services
 */
class Retrieve extends AbstractSoapClientBase
{
    /**
     * Sets the EmailCredentials SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\EmailCredentials $emailCredentials
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderEmailCredentials(\StructType\EmailCredentials $emailCredentials, $nameSpace = 'http://server.windeed.co.za/windeedengine/v2_0/cipc/', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'EmailCredentials', $emailCredentials, $mustUnderstand, $actor);
    }
    /**
     * Sets the TokenCredentials SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\TokenCredentials $tokenCredentials
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderTokenCredentials(\StructType\TokenCredentials $tokenCredentials, $nameSpace = 'http://server.windeed.co.za/windeedengine/v2_0/cipc/', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'TokenCredentials', $tokenCredentials, $mustUnderstand, $actor);
    }
    /**
     * Sets the WinDeedCredentials SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\WinDeedCredentials $winDeedCredentials
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderWinDeedCredentials(\StructType\WinDeedCredentials $winDeedCredentials, $nameSpace = 'http://server.windeed.co.za/windeedengine/v2_0/cipc/', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'WinDeedCredentials', $winDeedCredentials, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named RetrieveSearchResult
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: EmailCredentials, TokenCredentials, WinDeedCredentials
     * - SOAPHeaderNamespaces: http://server.windeed.co.za/windeedengine/v2_0/cipc/, http://server.windeed.co.za/windeedengine/v2_0/cipc/, http://server.windeed.co.za/windeedengine/v2_0/cipc/
     * - SOAPHeaderTypes: \StructType\EmailCredentials, \StructType\TokenCredentials, \StructType\WinDeedCredentials
     * - SOAPHeaders: required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RetrieveSearchResult $parameters
     * @return \StructType\RetrieveSearchResultResponse|bool
     */
    public function RetrieveSearchResult(\StructType\RetrieveSearchResult $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->RetrieveSearchResult($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RetrieveSearchRequest
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: EmailCredentials, TokenCredentials, WinDeedCredentials
     * - SOAPHeaderNamespaces: http://server.windeed.co.za/windeedengine/v2_0/cipc/, http://server.windeed.co.za/windeedengine/v2_0/cipc/, http://server.windeed.co.za/windeedengine/v2_0/cipc/
     * - SOAPHeaderTypes: \StructType\EmailCredentials, \StructType\TokenCredentials, \StructType\WinDeedCredentials
     * - SOAPHeaders: required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RetrieveSearchRequest $parameters
     * @return \StructType\RetrieveSearchRequestResponse|bool
     */
    public function RetrieveSearchRequest(\StructType\RetrieveSearchRequest $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->RetrieveSearchRequest($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RetrieveResponse
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: EmailCredentials, TokenCredentials, WinDeedCredentials
     * - SOAPHeaderNamespaces: http://server.windeed.co.za/windeedengine/v2_0/cipc/, http://server.windeed.co.za/windeedengine/v2_0/cipc/, http://server.windeed.co.za/windeedengine/v2_0/cipc/
     * - SOAPHeaderTypes: \StructType\EmailCredentials, \StructType\TokenCredentials, \StructType\WinDeedCredentials
     * - SOAPHeaders: required, required, required
     * - documentation: Returns the result if it has finished processing but and removes it from the in memory result list
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RetrieveResponse $parameters
     * @return \StructType\RetrieveResponseResponse|bool
     */
    public function RetrieveResponse(\StructType\RetrieveResponse $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->RetrieveResponse($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RetrieveOldResponse
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: EmailCredentials, TokenCredentials, WinDeedCredentials
     * - SOAPHeaderNamespaces: http://server.windeed.co.za/windeedengine/v2_0/cipc/, http://server.windeed.co.za/windeedengine/v2_0/cipc/, http://server.windeed.co.za/windeedengine/v2_0/cipc/
     * - SOAPHeaderTypes: \StructType\EmailCredentials, \StructType\TokenCredentials, \StructType\WinDeedCredentials
     * - SOAPHeaders: required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RetrieveOldResponse $parameters
     * @return \StructType\RetrieveOldResponseResponse|bool
     */
    public function RetrieveOldResponse(\StructType\RetrieveOldResponse $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->RetrieveOldResponse($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RetrieveOldRequest
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: EmailCredentials, TokenCredentials, WinDeedCredentials
     * - SOAPHeaderNamespaces: http://server.windeed.co.za/windeedengine/v2_0/cipc/, http://server.windeed.co.za/windeedengine/v2_0/cipc/, http://server.windeed.co.za/windeedengine/v2_0/cipc/
     * - SOAPHeaderTypes: \StructType\EmailCredentials, \StructType\TokenCredentials, \StructType\WinDeedCredentials
     * - SOAPHeaders: required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RetrieveOldRequest $parameters
     * @return \StructType\RetrieveOldRequestResponse|bool
     */
    public function RetrieveOldRequest(\StructType\RetrieveOldRequest $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->RetrieveOldRequest($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\RetrieveOldRequestResponse|\StructType\RetrieveOldResponseResponse|\StructType\RetrieveResponseResponse|\StructType\RetrieveSearchRequestResponse|\StructType\RetrieveSearchResultResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
