<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Request ServiceType
 * @subpackage Services
 */
class Request extends AbstractSoapClientBase
{
    /**
     * Sets the EmailCredentials SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\EmailCredentials $emailCredentials
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderEmailCredentials(\StructType\EmailCredentials $emailCredentials, $nameSpace = 'http://server.windeed.co.za/windeedengine/v2_0/cipc/', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'EmailCredentials', $emailCredentials, $mustUnderstand, $actor);
    }
    /**
     * Sets the TokenCredentials SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\TokenCredentials $tokenCredentials
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderTokenCredentials(\StructType\TokenCredentials $tokenCredentials, $nameSpace = 'http://server.windeed.co.za/windeedengine/v2_0/cipc/', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'TokenCredentials', $tokenCredentials, $mustUnderstand, $actor);
    }
    /**
     * Sets the WinDeedCredentials SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\WinDeedCredentials $winDeedCredentials
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderWinDeedCredentials(\StructType\WinDeedCredentials $winDeedCredentials, $nameSpace = 'http://server.windeed.co.za/windeedengine/v2_0/cipc/', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'WinDeedCredentials', $winDeedCredentials, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named RequestCompleted
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: EmailCredentials, TokenCredentials, WinDeedCredentials
     * - SOAPHeaderNamespaces: http://server.windeed.co.za/windeedengine/v2_0/cipc/, http://server.windeed.co.za/windeedengine/v2_0/cipc/, http://server.windeed.co.za/windeedengine/v2_0/cipc/
     * - SOAPHeaderTypes: \StructType\EmailCredentials, \StructType\TokenCredentials, \StructType\WinDeedCredentials
     * - SOAPHeaders: required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RequestCompleted $parameters
     * @return \StructType\RequestCompletedResponse|bool
     */
    public function RequestCompleted(\StructType\RequestCompleted $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->RequestCompleted($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RequestPrintout
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: EmailCredentials, TokenCredentials, WinDeedCredentials
     * - SOAPHeaderNamespaces: http://server.windeed.co.za/windeedengine/v2_0/cipc/, http://server.windeed.co.za/windeedengine/v2_0/cipc/, http://server.windeed.co.za/windeedengine/v2_0/cipc/
     * - SOAPHeaderTypes: \StructType\EmailCredentials, \StructType\TokenCredentials, \StructType\WinDeedCredentials
     * - SOAPHeaders: required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RequestPrintout $parameters
     * @return \StructType\RequestPrintoutResponse|bool
     */
    public function RequestPrintout(\StructType\RequestPrintout $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->RequestPrintout($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RequestPrintoutWithStamp
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: EmailCredentials, TokenCredentials, WinDeedCredentials
     * - SOAPHeaderNamespaces: http://server.windeed.co.za/windeedengine/v2_0/cipc/, http://server.windeed.co.za/windeedengine/v2_0/cipc/, http://server.windeed.co.za/windeedengine/v2_0/cipc/
     * - SOAPHeaderTypes: \StructType\EmailCredentials, \StructType\TokenCredentials, \StructType\WinDeedCredentials
     * - SOAPHeaders: required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RequestPrintoutWithStamp $parameters
     * @return \StructType\RequestPrintoutWithStampResponse|bool
     */
    public function RequestPrintoutWithStamp(\StructType\RequestPrintoutWithStamp $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->RequestPrintoutWithStamp($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RequestPasswordChange
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RequestPasswordChange $parameters
     * @return \StructType\RequestPasswordChangeResponse|bool
     */
    public function RequestPasswordChange(\StructType\RequestPasswordChange $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->RequestPasswordChange($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\RequestCompletedResponse|\StructType\RequestPasswordChangeResponse|\StructType\RequestPrintoutResponse|\StructType\RequestPrintoutWithStampResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
