<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Authenticate ServiceType
 * @subpackage Services
 */
class Authenticate extends AbstractSoapClientBase
{
    /**
     * Sets the EmailCredentials SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\EmailCredentials $emailCredentials
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderEmailCredentials(\StructType\EmailCredentials $emailCredentials, $nameSpace = 'http://server.windeed.co.za/windeedengine/v2_0/cipc/', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'EmailCredentials', $emailCredentials, $mustUnderstand, $actor);
    }
    /**
     * Sets the TokenCredentials SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\TokenCredentials $tokenCredentials
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderTokenCredentials(\StructType\TokenCredentials $tokenCredentials, $nameSpace = 'http://server.windeed.co.za/windeedengine/v2_0/cipc/', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'TokenCredentials', $tokenCredentials, $mustUnderstand, $actor);
    }
    /**
     * Sets the WinDeedCredentials SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\WinDeedCredentials $winDeedCredentials
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderWinDeedCredentials(\StructType\WinDeedCredentials $winDeedCredentials, $nameSpace = 'http://server.windeed.co.za/windeedengine/v2_0/cipc/', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'WinDeedCredentials', $winDeedCredentials, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named Authenticate
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: EmailCredentials, TokenCredentials, WinDeedCredentials
     * - SOAPHeaderNamespaces: http://server.windeed.co.za/windeedengine/v2_0/cipc/, http://server.windeed.co.za/windeedengine/v2_0/cipc/, http://server.windeed.co.za/windeedengine/v2_0/cipc/
     * - SOAPHeaderTypes: \StructType\EmailCredentials, \StructType\TokenCredentials, \StructType\WinDeedCredentials
     * - SOAPHeaders: required, required, required
     * - documentation: This method is used to validate a user's login credentials.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Authenticate $parameters
     * @return \StructType\AuthenticateResponse|bool
     */
    public function Authenticate(\StructType\Authenticate $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->Authenticate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\AuthenticateResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
