<?php

namespace EnumType;

/**
 * This class stands for LoginStatus EnumType
 * @subpackage Enumerations
 */
class LoginStatus
{
    /**
     * Constant for value 'Unknown'
     * @return string 'Unknown'
     */
    const VALUE_UNKNOWN = 'Unknown';
    /**
     * Constant for value 'Success'
     * @return string 'Success'
     */
    const VALUE_SUCCESS = 'Success';
    /**
     * Constant for value 'InvalidLogin'
     * @return string 'InvalidLogin'
     */
    const VALUE_INVALID_LOGIN = 'InvalidLogin';
    /**
     * Constant for value 'DisabledUser'
     * @return string 'DisabledUser'
     */
    const VALUE_DISABLED_USER = 'DisabledUser';
    /**
     * Constant for value 'DisabledCompany'
     * @return string 'DisabledCompany'
     */
    const VALUE_DISABLED_COMPANY = 'DisabledCompany';
    /**
     * Constant for value 'NoClearance'
     * @return string 'NoClearance'
     */
    const VALUE_NO_CLEARANCE = 'NoClearance';
    /**
     * Constant for value 'DuplicateEmail'
     * @return string 'DuplicateEmail'
     */
    const VALUE_DUPLICATE_EMAIL = 'DuplicateEmail';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_UNKNOWN
     * @uses self::VALUE_SUCCESS
     * @uses self::VALUE_INVALID_LOGIN
     * @uses self::VALUE_DISABLED_USER
     * @uses self::VALUE_DISABLED_COMPANY
     * @uses self::VALUE_NO_CLEARANCE
     * @uses self::VALUE_DUPLICATE_EMAIL
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_UNKNOWN,
            self::VALUE_SUCCESS,
            self::VALUE_INVALID_LOGIN,
            self::VALUE_DISABLED_USER,
            self::VALUE_DISABLED_COMPANY,
            self::VALUE_NO_CLEARANCE,
            self::VALUE_DUPLICATE_EMAIL,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
