<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfDirectorListItem ArrayType
 * @subpackage Arrays
 */
class ArrayOfDirectorListItem extends AbstractStructArrayBase
{
    /**
     * The DirectorListItem
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DirectorListItem[]
     */
    public $DirectorListItem;
    /**
     * Constructor method for ArrayOfDirectorListItem
     * @uses ArrayOfDirectorListItem::setDirectorListItem()
     * @param \StructType\DirectorListItem[] $directorListItem
     */
    public function __construct(array $directorListItem = array())
    {
        $this
            ->setDirectorListItem($directorListItem);
    }
    /**
     * Get DirectorListItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DirectorListItem[]|null
     */
    public function getDirectorListItem()
    {
        return isset($this->DirectorListItem) ? $this->DirectorListItem : null;
    }
    /**
     * Set DirectorListItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\DirectorListItem[] $directorListItem
     * @return \ArrayType\ArrayOfDirectorListItem
     */
    public function setDirectorListItem(array $directorListItem = array())
    {
        foreach ($directorListItem as $arrayOfDirectorListItemDirectorListItemItem) {
            // validation for constraint: itemType
            if (!$arrayOfDirectorListItemDirectorListItemItem instanceof \StructType\DirectorListItem) {
                throw new \InvalidArgumentException(sprintf('The DirectorListItem property can only contain items of \StructType\DirectorListItem, "%s" given', is_object($arrayOfDirectorListItemDirectorListItemItem) ? get_class($arrayOfDirectorListItemDirectorListItemItem) : gettype($arrayOfDirectorListItemDirectorListItemItem)), __LINE__);
            }
        }
        if (is_null($directorListItem) || (is_array($directorListItem) && empty($directorListItem))) {
            unset($this->DirectorListItem);
        } else {
            $this->DirectorListItem = $directorListItem;
        }
        return $this;
    }
    /**
     * Add item to DirectorListItem value
     * @throws \InvalidArgumentException
     * @param \StructType\DirectorListItem $item
     * @return \ArrayType\ArrayOfDirectorListItem
     */
    public function addToDirectorListItem(\StructType\DirectorListItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DirectorListItem) {
            throw new \InvalidArgumentException(sprintf('The DirectorListItem property can only contain items of \StructType\DirectorListItem, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->DirectorListItem[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\DirectorListItem|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\DirectorListItem|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\DirectorListItem|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\DirectorListItem|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\DirectorListItem|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string DirectorListItem
     */
    public function getAttributeName()
    {
        return 'DirectorListItem';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfDirectorListItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
