<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfAuditor ArrayType
 * @subpackage Arrays
 */
class ArrayOfAuditor extends AbstractStructArrayBase
{
    /**
     * The Auditor
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Auditor[]
     */
    public $Auditor;
    /**
     * Constructor method for ArrayOfAuditor
     * @uses ArrayOfAuditor::setAuditor()
     * @param \StructType\Auditor[] $auditor
     */
    public function __construct(array $auditor = array())
    {
        $this
            ->setAuditor($auditor);
    }
    /**
     * Get Auditor value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Auditor[]|null
     */
    public function getAuditor()
    {
        return isset($this->Auditor) ? $this->Auditor : null;
    }
    /**
     * Set Auditor value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Auditor[] $auditor
     * @return \ArrayType\ArrayOfAuditor
     */
    public function setAuditor(array $auditor = array())
    {
        foreach ($auditor as $arrayOfAuditorAuditorItem) {
            // validation for constraint: itemType
            if (!$arrayOfAuditorAuditorItem instanceof \StructType\Auditor) {
                throw new \InvalidArgumentException(sprintf('The Auditor property can only contain items of \StructType\Auditor, "%s" given', is_object($arrayOfAuditorAuditorItem) ? get_class($arrayOfAuditorAuditorItem) : gettype($arrayOfAuditorAuditorItem)), __LINE__);
            }
        }
        if (is_null($auditor) || (is_array($auditor) && empty($auditor))) {
            unset($this->Auditor);
        } else {
            $this->Auditor = $auditor;
        }
        return $this;
    }
    /**
     * Add item to Auditor value
     * @throws \InvalidArgumentException
     * @param \StructType\Auditor $item
     * @return \ArrayType\ArrayOfAuditor
     */
    public function addToAuditor(\StructType\Auditor $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Auditor) {
            throw new \InvalidArgumentException(sprintf('The Auditor property can only contain items of \StructType\Auditor, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Auditor[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Auditor|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Auditor|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Auditor|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Auditor|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Auditor|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Auditor
     */
    public function getAttributeName()
    {
        return 'Auditor';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfAuditor
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
