<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://server2.windeed.co.za/WinDeedEngine3/V2_0/cipc.asmx?WSDL',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://server2.windeed.co.za/WinDeedEngine3/V2_0/cipc.asmx?WSDL',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Check ServiceType
 */
$check = new \ServiceType\Check($options);
$check->setSoapHeaderEmailCredentials(new \StructType\EmailCredentials());
$check->setSoapHeaderTokenCredentials(new \StructType\TokenCredentials());
$check->setSoapHeaderWinDeedCredentials(new \StructType\WinDeedCredentials());
/**
 * Sample call for CheckCreditLimitForBatchSearch operation/method
 */
if ($check->CheckCreditLimitForBatchSearch(new \StructType\CheckCreditLimitForBatchSearch()) !== false) {
    print_r($check->getResult());
} else {
    print_r($check->getLastError());
}
/**
 * Sample call for CheckCredentials operation/method
 */
if ($check->CheckCredentials(new \StructType\CheckCredentials()) !== false) {
    print_r($check->getResult());
} else {
    print_r($check->getLastError());
}
/**
 * Samples for Retrieve ServiceType
 */
$retrieve = new \ServiceType\Retrieve($options);
$retrieve->setSoapHeaderEmailCredentials(new \StructType\EmailCredentials());
$retrieve->setSoapHeaderTokenCredentials(new \StructType\TokenCredentials());
$retrieve->setSoapHeaderWinDeedCredentials(new \StructType\WinDeedCredentials());
/**
 * Sample call for RetrieveSearchResult operation/method
 */
if ($retrieve->RetrieveSearchResult(new \StructType\RetrieveSearchResult()) !== false) {
    print_r($retrieve->getResult());
} else {
    print_r($retrieve->getLastError());
}
/**
 * Sample call for RetrieveSearchRequest operation/method
 */
if ($retrieve->RetrieveSearchRequest(new \StructType\RetrieveSearchRequest()) !== false) {
    print_r($retrieve->getResult());
} else {
    print_r($retrieve->getLastError());
}
/**
 * Sample call for RetrieveResponse operation/method
 */
if ($retrieve->RetrieveResponse(new \StructType\RetrieveResponse()) !== false) {
    print_r($retrieve->getResult());
} else {
    print_r($retrieve->getLastError());
}
/**
 * Sample call for RetrieveOldResponse operation/method
 */
if ($retrieve->RetrieveOldResponse(new \StructType\RetrieveOldResponse()) !== false) {
    print_r($retrieve->getResult());
} else {
    print_r($retrieve->getLastError());
}
/**
 * Sample call for RetrieveOldRequest operation/method
 */
if ($retrieve->RetrieveOldRequest(new \StructType\RetrieveOldRequest()) !== false) {
    print_r($retrieve->getResult());
} else {
    print_r($retrieve->getLastError());
}
/**
 * Samples for Place ServiceType
 */
$place = new \ServiceType\Place($options);
$place->setSoapHeaderEmailCredentials(new \StructType\EmailCredentials());
$place->setSoapHeaderTokenCredentials(new \StructType\TokenCredentials());
$place->setSoapHeaderWinDeedCredentials(new \StructType\WinDeedCredentials());
/**
 * Sample call for PlaceRequest operation/method
 */
if ($place->PlaceRequest(new \StructType\PlaceRequest()) !== false) {
    print_r($place->getResult());
} else {
    print_r($place->getLastError());
}
/**
 * Samples for Peek ServiceType
 */
$peek = new \ServiceType\Peek($options);
$peek->setSoapHeaderEmailCredentials(new \StructType\EmailCredentials());
$peek->setSoapHeaderTokenCredentials(new \StructType\TokenCredentials());
$peek->setSoapHeaderWinDeedCredentials(new \StructType\WinDeedCredentials());
/**
 * Sample call for PeekResponse operation/method
 */
if ($peek->PeekResponse(new \StructType\PeekResponse()) !== false) {
    print_r($peek->getResult());
} else {
    print_r($peek->getLastError());
}
/**
 * Samples for Request ServiceType
 */
$request = new \ServiceType\Request($options);
$request->setSoapHeaderEmailCredentials(new \StructType\EmailCredentials());
$request->setSoapHeaderTokenCredentials(new \StructType\TokenCredentials());
$request->setSoapHeaderWinDeedCredentials(new \StructType\WinDeedCredentials());
/**
 * Sample call for RequestCompleted operation/method
 */
if ($request->RequestCompleted(new \StructType\RequestCompleted()) !== false) {
    print_r($request->getResult());
} else {
    print_r($request->getLastError());
}
/**
 * Sample call for RequestPrintout operation/method
 */
if ($request->RequestPrintout(new \StructType\RequestPrintout()) !== false) {
    print_r($request->getResult());
} else {
    print_r($request->getLastError());
}
/**
 * Sample call for RequestPrintoutWithStamp operation/method
 */
if ($request->RequestPrintoutWithStamp(new \StructType\RequestPrintoutWithStamp()) !== false) {
    print_r($request->getResult());
} else {
    print_r($request->getLastError());
}
/**
 * Sample call for RequestPasswordChange operation/method
 */
if ($request->RequestPasswordChange(new \StructType\RequestPasswordChange()) !== false) {
    print_r($request->getResult());
} else {
    print_r($request->getLastError());
}
/**
 * Samples for Authenticate ServiceType
 */
$authenticate = new \ServiceType\Authenticate($options);
$authenticate->setSoapHeaderEmailCredentials(new \StructType\EmailCredentials());
$authenticate->setSoapHeaderTokenCredentials(new \StructType\TokenCredentials());
$authenticate->setSoapHeaderWinDeedCredentials(new \StructType\WinDeedCredentials());
/**
 * Sample call for Authenticate operation/method
 */
if ($authenticate->Authenticate(new \StructType\Authenticate()) !== false) {
    print_r($authenticate->getResult());
} else {
    print_r($authenticate->getLastError());
}
/**
 * Samples for Change ServiceType
 */
$change = new \ServiceType\Change($options);
$change->setSoapHeaderEmailCredentials(new \StructType\EmailCredentials());
$change->setSoapHeaderTokenCredentials(new \StructType\TokenCredentials());
$change->setSoapHeaderWinDeedCredentials(new \StructType\WinDeedCredentials());
/**
 * Sample call for ChangePassword operation/method
 */
if ($change->ChangePassword(new \StructType\ChangePassword()) !== false) {
    print_r($change->getResult());
} else {
    print_r($change->getLastError());
}
/**
 * Samples for Password ServiceType
 */
$password = new \ServiceType\Password($options);
/**
 * Sample call for PasswordActivationKeyIsValid operation/method
 */
if ($password->PasswordActivationKeyIsValid(new \StructType\PasswordActivationKeyIsValid()) !== false) {
    print_r($password->getResult());
} else {
    print_r($password->getLastError());
}
/**
 * Samples for Set ServiceType
 */
$set = new \ServiceType\Set($options);
/**
 * Sample call for SetPassword operation/method
 */
if ($set->SetPassword(new \StructType\SetPassword()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Samples for Reset ServiceType
 */
$reset = new \ServiceType\Reset($options);
/**
 * Sample call for ResetPassword operation/method
 */
if ($reset->ResetPassword(new \StructType\ResetPassword()) !== false) {
    print_r($reset->getResult());
} else {
    print_r($reset->getLastError());
}
