<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RetrieveSearchRequest StructType
 * @subpackage Structs
 */
class RetrieveSearchRequest extends AbstractStructBase
{
    /**
     * The referenceNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $referenceNumber;
    /**
     * Constructor method for RetrieveSearchRequest
     * @uses RetrieveSearchRequest::setReferenceNumber()
     * @param int $referenceNumber
     */
    public function __construct($referenceNumber = null)
    {
        $this
            ->setReferenceNumber($referenceNumber);
    }
    /**
     * Get referenceNumber value
     * @return int
     */
    public function getReferenceNumber()
    {
        return $this->referenceNumber;
    }
    /**
     * Set referenceNumber value
     * @param int $referenceNumber
     * @return \StructType\RetrieveSearchRequest
     */
    public function setReferenceNumber($referenceNumber = null)
    {
        // validation for constraint: int
        if (!is_null($referenceNumber) && !is_numeric($referenceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($referenceNumber)), __LINE__);
        }
        $this->referenceNumber = $referenceNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RetrieveSearchRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
