<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NaturalMember StructType
 * @subpackage Structs
 */
class NaturalMember extends MemberBase
{
    /**
     * The DateOfBirth
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $DateOfBirth;
    /**
     * The FirstName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FirstName;
    /**
     * The Surname
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Surname;
    /**
     * The IdNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IdNumber;
    /**
     * The Profession
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Profession;
    /**
     * The Initials
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Initials;
    /**
     * The Nationality
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CipcLookup
     */
    public $Nationality;
    /**
     * The UberLinks
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfNaturalUberLink
     */
    public $UberLinks;
    /**
     * Constructor method for NaturalMember
     * @uses NaturalMember::setDateOfBirth()
     * @uses NaturalMember::setFirstName()
     * @uses NaturalMember::setSurname()
     * @uses NaturalMember::setIdNumber()
     * @uses NaturalMember::setProfession()
     * @uses NaturalMember::setInitials()
     * @uses NaturalMember::setNationality()
     * @uses NaturalMember::setUberLinks()
     * @param string $dateOfBirth
     * @param string $firstName
     * @param string $surname
     * @param string $idNumber
     * @param string $profession
     * @param string $initials
     * @param \StructType\CipcLookup $nationality
     * @param \ArrayType\ArrayOfNaturalUberLink $uberLinks
     */
    public function __construct($dateOfBirth = null, $firstName = null, $surname = null, $idNumber = null, $profession = null, $initials = null, \StructType\CipcLookup $nationality = null, \ArrayType\ArrayOfNaturalUberLink $uberLinks = null)
    {
        $this
            ->setDateOfBirth($dateOfBirth)
            ->setFirstName($firstName)
            ->setSurname($surname)
            ->setIdNumber($idNumber)
            ->setProfession($profession)
            ->setInitials($initials)
            ->setNationality($nationality)
            ->setUberLinks($uberLinks);
    }
    /**
     * Get DateOfBirth value
     * @return string
     */
    public function getDateOfBirth()
    {
        return $this->DateOfBirth;
    }
    /**
     * Set DateOfBirth value
     * @param string $dateOfBirth
     * @return \StructType\NaturalMember
     */
    public function setDateOfBirth($dateOfBirth = null)
    {
        // validation for constraint: string
        if (!is_null($dateOfBirth) && !is_string($dateOfBirth)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateOfBirth)), __LINE__);
        }
        $this->DateOfBirth = $dateOfBirth;
        return $this;
    }
    /**
     * Get FirstName value
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->FirstName;
    }
    /**
     * Set FirstName value
     * @param string $firstName
     * @return \StructType\NaturalMember
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($firstName)), __LINE__);
        }
        $this->FirstName = $firstName;
        return $this;
    }
    /**
     * Get Surname value
     * @return string|null
     */
    public function getSurname()
    {
        return $this->Surname;
    }
    /**
     * Set Surname value
     * @param string $surname
     * @return \StructType\NaturalMember
     */
    public function setSurname($surname = null)
    {
        // validation for constraint: string
        if (!is_null($surname) && !is_string($surname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($surname)), __LINE__);
        }
        $this->Surname = $surname;
        return $this;
    }
    /**
     * Get IdNumber value
     * @return string|null
     */
    public function getIdNumber()
    {
        return $this->IdNumber;
    }
    /**
     * Set IdNumber value
     * @param string $idNumber
     * @return \StructType\NaturalMember
     */
    public function setIdNumber($idNumber = null)
    {
        // validation for constraint: string
        if (!is_null($idNumber) && !is_string($idNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($idNumber)), __LINE__);
        }
        $this->IdNumber = $idNumber;
        return $this;
    }
    /**
     * Get Profession value
     * @return string|null
     */
    public function getProfession()
    {
        return $this->Profession;
    }
    /**
     * Set Profession value
     * @param string $profession
     * @return \StructType\NaturalMember
     */
    public function setProfession($profession = null)
    {
        // validation for constraint: string
        if (!is_null($profession) && !is_string($profession)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($profession)), __LINE__);
        }
        $this->Profession = $profession;
        return $this;
    }
    /**
     * Get Initials value
     * @return string|null
     */
    public function getInitials()
    {
        return $this->Initials;
    }
    /**
     * Set Initials value
     * @param string $initials
     * @return \StructType\NaturalMember
     */
    public function setInitials($initials = null)
    {
        // validation for constraint: string
        if (!is_null($initials) && !is_string($initials)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($initials)), __LINE__);
        }
        $this->Initials = $initials;
        return $this;
    }
    /**
     * Get Nationality value
     * @return \StructType\CipcLookup|null
     */
    public function getNationality()
    {
        return $this->Nationality;
    }
    /**
     * Set Nationality value
     * @param \StructType\CipcLookup $nationality
     * @return \StructType\NaturalMember
     */
    public function setNationality(\StructType\CipcLookup $nationality = null)
    {
        $this->Nationality = $nationality;
        return $this;
    }
    /**
     * Get UberLinks value
     * @return \ArrayType\ArrayOfNaturalUberLink|null
     */
    public function getUberLinks()
    {
        return $this->UberLinks;
    }
    /**
     * Set UberLinks value
     * @param \ArrayType\ArrayOfNaturalUberLink $uberLinks
     * @return \StructType\NaturalMember
     */
    public function setUberLinks(\ArrayType\ArrayOfNaturalUberLink $uberLinks = null)
    {
        $this->UberLinks = $uberLinks;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\NaturalMember
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
