<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ErrorResponse StructType
 * @subpackage Structs
 */
class ErrorResponse extends ResponseBase
{
    /**
     * The IsMessage
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsMessage;
    /**
     * The Errors
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfString
     */
    public $Errors;
    /**
     * The ErrorType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ErrorType;
    /**
     * Constructor method for ErrorResponse
     * @uses ErrorResponse::setIsMessage()
     * @uses ErrorResponse::setErrors()
     * @uses ErrorResponse::setErrorType()
     * @param bool $isMessage
     * @param \ArrayType\ArrayOfString $errors
     * @param string $errorType
     */
    public function __construct($isMessage = null, \ArrayType\ArrayOfString $errors = null, $errorType = null)
    {
        $this
            ->setIsMessage($isMessage)
            ->setErrors($errors)
            ->setErrorType($errorType);
    }
    /**
     * Get IsMessage value
     * @return bool
     */
    public function getIsMessage()
    {
        return $this->IsMessage;
    }
    /**
     * Set IsMessage value
     * @param bool $isMessage
     * @return \StructType\ErrorResponse
     */
    public function setIsMessage($isMessage = null)
    {
        // validation for constraint: boolean
        if (!is_null($isMessage) && !is_bool($isMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isMessage)), __LINE__);
        }
        $this->IsMessage = $isMessage;
        return $this;
    }
    /**
     * Get Errors value
     * @return \ArrayType\ArrayOfString|null
     */
    public function getErrors()
    {
        return $this->Errors;
    }
    /**
     * Set Errors value
     * @param \ArrayType\ArrayOfString $errors
     * @return \StructType\ErrorResponse
     */
    public function setErrors(\ArrayType\ArrayOfString $errors = null)
    {
        $this->Errors = $errors;
        return $this;
    }
    /**
     * Get ErrorType value
     * @return string|null
     */
    public function getErrorType()
    {
        return $this->ErrorType;
    }
    /**
     * Set ErrorType value
     * @param string $errorType
     * @return \StructType\ErrorResponse
     */
    public function setErrorType($errorType = null)
    {
        // validation for constraint: string
        if (!is_null($errorType) && !is_string($errorType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($errorType)), __LINE__);
        }
        $this->ErrorType = $errorType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ErrorResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
