<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DirectorReportResponseBase StructType
 * @subpackage Structs
 */
abstract class DirectorReportResponseBase extends AbstractStructBase
{
    /**
     * The DbKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DbKey;
    /**
     * The SouthAfricanResident
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $SouthAfricanResident;
    /**
     * The Country
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CipcLookup
     */
    public $Country;
    /**
     * The AssociatedCompanies
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfAssociatedCompany
     */
    public $AssociatedCompanies;
    /**
     * The Nationality
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CipcLookup
     */
    public $Nationality;
    /**
     * Constructor method for DirectorReportResponseBase
     * @uses DirectorReportResponseBase::setDbKey()
     * @uses DirectorReportResponseBase::setSouthAfricanResident()
     * @uses DirectorReportResponseBase::setCountry()
     * @uses DirectorReportResponseBase::setAssociatedCompanies()
     * @uses DirectorReportResponseBase::setNationality()
     * @param int $dbKey
     * @param bool $southAfricanResident
     * @param \StructType\CipcLookup $country
     * @param \ArrayType\ArrayOfAssociatedCompany $associatedCompanies
     * @param \StructType\CipcLookup $nationality
     */
    public function __construct($dbKey = null, $southAfricanResident = null, \StructType\CipcLookup $country = null, \ArrayType\ArrayOfAssociatedCompany $associatedCompanies = null, \StructType\CipcLookup $nationality = null)
    {
        $this
            ->setDbKey($dbKey)
            ->setSouthAfricanResident($southAfricanResident)
            ->setCountry($country)
            ->setAssociatedCompanies($associatedCompanies)
            ->setNationality($nationality);
    }
    /**
     * Get DbKey value
     * @return int
     */
    public function getDbKey()
    {
        return $this->DbKey;
    }
    /**
     * Set DbKey value
     * @param int $dbKey
     * @return \StructType\DirectorReportResponseBase
     */
    public function setDbKey($dbKey = null)
    {
        // validation for constraint: int
        if (!is_null($dbKey) && !is_numeric($dbKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($dbKey)), __LINE__);
        }
        $this->DbKey = $dbKey;
        return $this;
    }
    /**
     * Get SouthAfricanResident value
     * @return bool
     */
    public function getSouthAfricanResident()
    {
        return $this->SouthAfricanResident;
    }
    /**
     * Set SouthAfricanResident value
     * @param bool $southAfricanResident
     * @return \StructType\DirectorReportResponseBase
     */
    public function setSouthAfricanResident($southAfricanResident = null)
    {
        // validation for constraint: boolean
        if (!is_null($southAfricanResident) && !is_bool($southAfricanResident)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($southAfricanResident)), __LINE__);
        }
        $this->SouthAfricanResident = $southAfricanResident;
        return $this;
    }
    /**
     * Get Country value
     * @return \StructType\CipcLookup|null
     */
    public function getCountry()
    {
        return $this->Country;
    }
    /**
     * Set Country value
     * @param \StructType\CipcLookup $country
     * @return \StructType\DirectorReportResponseBase
     */
    public function setCountry(\StructType\CipcLookup $country = null)
    {
        $this->Country = $country;
        return $this;
    }
    /**
     * Get AssociatedCompanies value
     * @return \ArrayType\ArrayOfAssociatedCompany|null
     */
    public function getAssociatedCompanies()
    {
        return $this->AssociatedCompanies;
    }
    /**
     * Set AssociatedCompanies value
     * @param \ArrayType\ArrayOfAssociatedCompany $associatedCompanies
     * @return \StructType\DirectorReportResponseBase
     */
    public function setAssociatedCompanies(\ArrayType\ArrayOfAssociatedCompany $associatedCompanies = null)
    {
        $this->AssociatedCompanies = $associatedCompanies;
        return $this;
    }
    /**
     * Get Nationality value
     * @return \StructType\CipcLookup|null
     */
    public function getNationality()
    {
        return $this->Nationality;
    }
    /**
     * Set Nationality value
     * @param \StructType\CipcLookup $nationality
     * @return \StructType\DirectorReportResponseBase
     */
    public function setNationality(\StructType\CipcLookup $nationality = null)
    {
        $this->Nationality = $nationality;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DirectorReportResponseBase
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
