<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreditCheckResponse StructType
 * @subpackage Structs
 */
class CreditCheckResponse extends AbstractStructBase
{
    /**
     * The CreditCheckStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CreditCheckStatus;
    /**
     * The Message
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Message;
    /**
     * Constructor method for CreditCheckResponse
     * @uses CreditCheckResponse::setCreditCheckStatus()
     * @uses CreditCheckResponse::setMessage()
     * @param string $creditCheckStatus
     * @param string $message
     */
    public function __construct($creditCheckStatus = null, $message = null)
    {
        $this
            ->setCreditCheckStatus($creditCheckStatus)
            ->setMessage($message);
    }
    /**
     * Get CreditCheckStatus value
     * @return string
     */
    public function getCreditCheckStatus()
    {
        return $this->CreditCheckStatus;
    }
    /**
     * Set CreditCheckStatus value
     * @uses \EnumType\CreditCheckStatus::valueIsValid()
     * @uses \EnumType\CreditCheckStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $creditCheckStatus
     * @return \StructType\CreditCheckResponse
     */
    public function setCreditCheckStatus($creditCheckStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CreditCheckStatus::valueIsValid($creditCheckStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $creditCheckStatus, implode(', ', \EnumType\CreditCheckStatus::getValidValues())), __LINE__);
        }
        $this->CreditCheckStatus = $creditCheckStatus;
        return $this;
    }
    /**
     * Get Message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->Message;
    }
    /**
     * Set Message value
     * @param string $message
     * @return \StructType\CreditCheckResponse
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($message)), __LINE__);
        }
        $this->Message = $message;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CreditCheckResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
