<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CompanyListItem StructType
 * @subpackage Structs
 */
class CompanyListItem extends ListItemBase
{
    /**
     * The DbKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DbKey;
    /**
     * The RegistrationNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\RegistrationNumber
     */
    public $RegistrationNumber;
    /**
     * Constructor method for CompanyListItem
     * @uses CompanyListItem::setDbKey()
     * @uses CompanyListItem::setRegistrationNumber()
     * @param int $dbKey
     * @param \StructType\RegistrationNumber $registrationNumber
     */
    public function __construct($dbKey = null, \StructType\RegistrationNumber $registrationNumber = null)
    {
        $this
            ->setDbKey($dbKey)
            ->setRegistrationNumber($registrationNumber);
    }
    /**
     * Get DbKey value
     * @return int
     */
    public function getDbKey()
    {
        return $this->DbKey;
    }
    /**
     * Set DbKey value
     * @param int $dbKey
     * @return \StructType\CompanyListItem
     */
    public function setDbKey($dbKey = null)
    {
        // validation for constraint: int
        if (!is_null($dbKey) && !is_numeric($dbKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($dbKey)), __LINE__);
        }
        $this->DbKey = $dbKey;
        return $this;
    }
    /**
     * Get RegistrationNumber value
     * @return \StructType\RegistrationNumber|null
     */
    public function getRegistrationNumber()
    {
        return $this->RegistrationNumber;
    }
    /**
     * Set RegistrationNumber value
     * @param \StructType\RegistrationNumber $registrationNumber
     * @return \StructType\CompanyListItem
     */
    public function setRegistrationNumber(\StructType\RegistrationNumber $registrationNumber = null)
    {
        $this->RegistrationNumber = $registrationNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CompanyListItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
