<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CompanyInformation StructType
 * @subpackage Structs
 */
class CompanyInformation extends AbstractStructBase
{
    /**
     * The RegistrationDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $RegistrationDate;
    /**
     * The BusinessStartDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $BusinessStartDate;
    /**
     * The StatusDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $StatusDate;
    /**
     * The CkDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $CkDate;
    /**
     * The CkDateRecieved
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $CkDateRecieved;
    /**
     * The TypeDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $TypeDate;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The RegistrationNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\RegistrationNumber
     */
    public $RegistrationNumber;
    /**
     * The CompanyStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CipcLookup
     */
    public $CompanyStatus;
    /**
     * The EnterpriseType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CipcLookup
     */
    public $EnterpriseType;
    /**
     * The OldRegistrationNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OldRegistrationNumber;
    /**
     * The ShortName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ShortName;
    /**
     * The TranslatedName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TranslatedName;
    /**
     * The SicCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SicCode;
    /**
     * The PostalAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\BasicAddress
     */
    public $PostalAddress;
    /**
     * The PhysicalAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\BasicAddress
     */
    public $PhysicalAddress;
    /**
     * The Region
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CipcLookup
     */
    public $Region;
    /**
     * The Country
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CipcLookup
     */
    public $Country;
    /**
     * The CountryOfOrigin
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CountryOfOrigin;
    /**
     * The Industry
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CipcLookup
     */
    public $Industry;
    /**
     * The ConversionNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ConversionNumber;
    /**
     * Constructor method for CompanyInformation
     * @uses CompanyInformation::setRegistrationDate()
     * @uses CompanyInformation::setBusinessStartDate()
     * @uses CompanyInformation::setStatusDate()
     * @uses CompanyInformation::setCkDate()
     * @uses CompanyInformation::setCkDateRecieved()
     * @uses CompanyInformation::setTypeDate()
     * @uses CompanyInformation::setName()
     * @uses CompanyInformation::setRegistrationNumber()
     * @uses CompanyInformation::setCompanyStatus()
     * @uses CompanyInformation::setEnterpriseType()
     * @uses CompanyInformation::setOldRegistrationNumber()
     * @uses CompanyInformation::setShortName()
     * @uses CompanyInformation::setTranslatedName()
     * @uses CompanyInformation::setSicCode()
     * @uses CompanyInformation::setPostalAddress()
     * @uses CompanyInformation::setPhysicalAddress()
     * @uses CompanyInformation::setRegion()
     * @uses CompanyInformation::setCountry()
     * @uses CompanyInformation::setCountryOfOrigin()
     * @uses CompanyInformation::setIndustry()
     * @uses CompanyInformation::setConversionNumber()
     * @param string $registrationDate
     * @param string $businessStartDate
     * @param string $statusDate
     * @param string $ckDate
     * @param string $ckDateRecieved
     * @param string $typeDate
     * @param string $name
     * @param \StructType\RegistrationNumber $registrationNumber
     * @param \StructType\CipcLookup $companyStatus
     * @param \StructType\CipcLookup $enterpriseType
     * @param string $oldRegistrationNumber
     * @param string $shortName
     * @param string $translatedName
     * @param string $sicCode
     * @param \StructType\BasicAddress $postalAddress
     * @param \StructType\BasicAddress $physicalAddress
     * @param \StructType\CipcLookup $region
     * @param \StructType\CipcLookup $country
     * @param string $countryOfOrigin
     * @param \StructType\CipcLookup $industry
     * @param string $conversionNumber
     */
    public function __construct($registrationDate = null, $businessStartDate = null, $statusDate = null, $ckDate = null, $ckDateRecieved = null, $typeDate = null, $name = null, \StructType\RegistrationNumber $registrationNumber = null, \StructType\CipcLookup $companyStatus = null, \StructType\CipcLookup $enterpriseType = null, $oldRegistrationNumber = null, $shortName = null, $translatedName = null, $sicCode = null, \StructType\BasicAddress $postalAddress = null, \StructType\BasicAddress $physicalAddress = null, \StructType\CipcLookup $region = null, \StructType\CipcLookup $country = null, $countryOfOrigin = null, \StructType\CipcLookup $industry = null, $conversionNumber = null)
    {
        $this
            ->setRegistrationDate($registrationDate)
            ->setBusinessStartDate($businessStartDate)
            ->setStatusDate($statusDate)
            ->setCkDate($ckDate)
            ->setCkDateRecieved($ckDateRecieved)
            ->setTypeDate($typeDate)
            ->setName($name)
            ->setRegistrationNumber($registrationNumber)
            ->setCompanyStatus($companyStatus)
            ->setEnterpriseType($enterpriseType)
            ->setOldRegistrationNumber($oldRegistrationNumber)
            ->setShortName($shortName)
            ->setTranslatedName($translatedName)
            ->setSicCode($sicCode)
            ->setPostalAddress($postalAddress)
            ->setPhysicalAddress($physicalAddress)
            ->setRegion($region)
            ->setCountry($country)
            ->setCountryOfOrigin($countryOfOrigin)
            ->setIndustry($industry)
            ->setConversionNumber($conversionNumber);
    }
    /**
     * Get RegistrationDate value
     * @return string
     */
    public function getRegistrationDate()
    {
        return $this->RegistrationDate;
    }
    /**
     * Set RegistrationDate value
     * @param string $registrationDate
     * @return \StructType\CompanyInformation
     */
    public function setRegistrationDate($registrationDate = null)
    {
        // validation for constraint: string
        if (!is_null($registrationDate) && !is_string($registrationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($registrationDate)), __LINE__);
        }
        $this->RegistrationDate = $registrationDate;
        return $this;
    }
    /**
     * Get BusinessStartDate value
     * @return string
     */
    public function getBusinessStartDate()
    {
        return $this->BusinessStartDate;
    }
    /**
     * Set BusinessStartDate value
     * @param string $businessStartDate
     * @return \StructType\CompanyInformation
     */
    public function setBusinessStartDate($businessStartDate = null)
    {
        // validation for constraint: string
        if (!is_null($businessStartDate) && !is_string($businessStartDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($businessStartDate)), __LINE__);
        }
        $this->BusinessStartDate = $businessStartDate;
        return $this;
    }
    /**
     * Get StatusDate value
     * @return string
     */
    public function getStatusDate()
    {
        return $this->StatusDate;
    }
    /**
     * Set StatusDate value
     * @param string $statusDate
     * @return \StructType\CompanyInformation
     */
    public function setStatusDate($statusDate = null)
    {
        // validation for constraint: string
        if (!is_null($statusDate) && !is_string($statusDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($statusDate)), __LINE__);
        }
        $this->StatusDate = $statusDate;
        return $this;
    }
    /**
     * Get CkDate value
     * @return string
     */
    public function getCkDate()
    {
        return $this->CkDate;
    }
    /**
     * Set CkDate value
     * @param string $ckDate
     * @return \StructType\CompanyInformation
     */
    public function setCkDate($ckDate = null)
    {
        // validation for constraint: string
        if (!is_null($ckDate) && !is_string($ckDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ckDate)), __LINE__);
        }
        $this->CkDate = $ckDate;
        return $this;
    }
    /**
     * Get CkDateRecieved value
     * @return string
     */
    public function getCkDateRecieved()
    {
        return $this->CkDateRecieved;
    }
    /**
     * Set CkDateRecieved value
     * @param string $ckDateRecieved
     * @return \StructType\CompanyInformation
     */
    public function setCkDateRecieved($ckDateRecieved = null)
    {
        // validation for constraint: string
        if (!is_null($ckDateRecieved) && !is_string($ckDateRecieved)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ckDateRecieved)), __LINE__);
        }
        $this->CkDateRecieved = $ckDateRecieved;
        return $this;
    }
    /**
     * Get TypeDate value
     * @return string
     */
    public function getTypeDate()
    {
        return $this->TypeDate;
    }
    /**
     * Set TypeDate value
     * @param string $typeDate
     * @return \StructType\CompanyInformation
     */
    public function setTypeDate($typeDate = null)
    {
        // validation for constraint: string
        if (!is_null($typeDate) && !is_string($typeDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($typeDate)), __LINE__);
        }
        $this->TypeDate = $typeDate;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\CompanyInformation
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get RegistrationNumber value
     * @return \StructType\RegistrationNumber|null
     */
    public function getRegistrationNumber()
    {
        return $this->RegistrationNumber;
    }
    /**
     * Set RegistrationNumber value
     * @param \StructType\RegistrationNumber $registrationNumber
     * @return \StructType\CompanyInformation
     */
    public function setRegistrationNumber(\StructType\RegistrationNumber $registrationNumber = null)
    {
        $this->RegistrationNumber = $registrationNumber;
        return $this;
    }
    /**
     * Get CompanyStatus value
     * @return \StructType\CipcLookup|null
     */
    public function getCompanyStatus()
    {
        return $this->CompanyStatus;
    }
    /**
     * Set CompanyStatus value
     * @param \StructType\CipcLookup $companyStatus
     * @return \StructType\CompanyInformation
     */
    public function setCompanyStatus(\StructType\CipcLookup $companyStatus = null)
    {
        $this->CompanyStatus = $companyStatus;
        return $this;
    }
    /**
     * Get EnterpriseType value
     * @return \StructType\CipcLookup|null
     */
    public function getEnterpriseType()
    {
        return $this->EnterpriseType;
    }
    /**
     * Set EnterpriseType value
     * @param \StructType\CipcLookup $enterpriseType
     * @return \StructType\CompanyInformation
     */
    public function setEnterpriseType(\StructType\CipcLookup $enterpriseType = null)
    {
        $this->EnterpriseType = $enterpriseType;
        return $this;
    }
    /**
     * Get OldRegistrationNumber value
     * @return string|null
     */
    public function getOldRegistrationNumber()
    {
        return $this->OldRegistrationNumber;
    }
    /**
     * Set OldRegistrationNumber value
     * @param string $oldRegistrationNumber
     * @return \StructType\CompanyInformation
     */
    public function setOldRegistrationNumber($oldRegistrationNumber = null)
    {
        // validation for constraint: string
        if (!is_null($oldRegistrationNumber) && !is_string($oldRegistrationNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($oldRegistrationNumber)), __LINE__);
        }
        $this->OldRegistrationNumber = $oldRegistrationNumber;
        return $this;
    }
    /**
     * Get ShortName value
     * @return string|null
     */
    public function getShortName()
    {
        return $this->ShortName;
    }
    /**
     * Set ShortName value
     * @param string $shortName
     * @return \StructType\CompanyInformation
     */
    public function setShortName($shortName = null)
    {
        // validation for constraint: string
        if (!is_null($shortName) && !is_string($shortName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shortName)), __LINE__);
        }
        $this->ShortName = $shortName;
        return $this;
    }
    /**
     * Get TranslatedName value
     * @return string|null
     */
    public function getTranslatedName()
    {
        return $this->TranslatedName;
    }
    /**
     * Set TranslatedName value
     * @param string $translatedName
     * @return \StructType\CompanyInformation
     */
    public function setTranslatedName($translatedName = null)
    {
        // validation for constraint: string
        if (!is_null($translatedName) && !is_string($translatedName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($translatedName)), __LINE__);
        }
        $this->TranslatedName = $translatedName;
        return $this;
    }
    /**
     * Get SicCode value
     * @return string|null
     */
    public function getSicCode()
    {
        return $this->SicCode;
    }
    /**
     * Set SicCode value
     * @param string $sicCode
     * @return \StructType\CompanyInformation
     */
    public function setSicCode($sicCode = null)
    {
        // validation for constraint: string
        if (!is_null($sicCode) && !is_string($sicCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sicCode)), __LINE__);
        }
        $this->SicCode = $sicCode;
        return $this;
    }
    /**
     * Get PostalAddress value
     * @return \StructType\BasicAddress|null
     */
    public function getPostalAddress()
    {
        return $this->PostalAddress;
    }
    /**
     * Set PostalAddress value
     * @param \StructType\BasicAddress $postalAddress
     * @return \StructType\CompanyInformation
     */
    public function setPostalAddress(\StructType\BasicAddress $postalAddress = null)
    {
        $this->PostalAddress = $postalAddress;
        return $this;
    }
    /**
     * Get PhysicalAddress value
     * @return \StructType\BasicAddress|null
     */
    public function getPhysicalAddress()
    {
        return $this->PhysicalAddress;
    }
    /**
     * Set PhysicalAddress value
     * @param \StructType\BasicAddress $physicalAddress
     * @return \StructType\CompanyInformation
     */
    public function setPhysicalAddress(\StructType\BasicAddress $physicalAddress = null)
    {
        $this->PhysicalAddress = $physicalAddress;
        return $this;
    }
    /**
     * Get Region value
     * @return \StructType\CipcLookup|null
     */
    public function getRegion()
    {
        return $this->Region;
    }
    /**
     * Set Region value
     * @param \StructType\CipcLookup $region
     * @return \StructType\CompanyInformation
     */
    public function setRegion(\StructType\CipcLookup $region = null)
    {
        $this->Region = $region;
        return $this;
    }
    /**
     * Get Country value
     * @return \StructType\CipcLookup|null
     */
    public function getCountry()
    {
        return $this->Country;
    }
    /**
     * Set Country value
     * @param \StructType\CipcLookup $country
     * @return \StructType\CompanyInformation
     */
    public function setCountry(\StructType\CipcLookup $country = null)
    {
        $this->Country = $country;
        return $this;
    }
    /**
     * Get CountryOfOrigin value
     * @return string|null
     */
    public function getCountryOfOrigin()
    {
        return $this->CountryOfOrigin;
    }
    /**
     * Set CountryOfOrigin value
     * @param string $countryOfOrigin
     * @return \StructType\CompanyInformation
     */
    public function setCountryOfOrigin($countryOfOrigin = null)
    {
        // validation for constraint: string
        if (!is_null($countryOfOrigin) && !is_string($countryOfOrigin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($countryOfOrigin)), __LINE__);
        }
        $this->CountryOfOrigin = $countryOfOrigin;
        return $this;
    }
    /**
     * Get Industry value
     * @return \StructType\CipcLookup|null
     */
    public function getIndustry()
    {
        return $this->Industry;
    }
    /**
     * Set Industry value
     * @param \StructType\CipcLookup $industry
     * @return \StructType\CompanyInformation
     */
    public function setIndustry(\StructType\CipcLookup $industry = null)
    {
        $this->Industry = $industry;
        return $this;
    }
    /**
     * Get ConversionNumber value
     * @return string|null
     */
    public function getConversionNumber()
    {
        return $this->ConversionNumber;
    }
    /**
     * Set ConversionNumber value
     * @param string $conversionNumber
     * @return \StructType\CompanyInformation
     */
    public function setConversionNumber($conversionNumber = null)
    {
        // validation for constraint: string
        if (!is_null($conversionNumber) && !is_string($conversionNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($conversionNumber)), __LINE__);
        }
        $this->ConversionNumber = $conversionNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CompanyInformation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
