<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CompanyByNameRequest StructType
 * @subpackage Structs
 */
class CompanyByNameRequest extends CompanyRequest
{
    /**
     * The NameMatching
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $NameMatching;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * Constructor method for CompanyByNameRequest
     * @uses CompanyByNameRequest::setNameMatching()
     * @uses CompanyByNameRequest::setName()
     * @param string $nameMatching
     * @param string $name
     */
    public function __construct($nameMatching = null, $name = null)
    {
        $this
            ->setNameMatching($nameMatching)
            ->setName($name);
    }
    /**
     * Get NameMatching value
     * @return string
     */
    public function getNameMatching()
    {
        return $this->NameMatching;
    }
    /**
     * Set NameMatching value
     * @uses \EnumType\NameMatching::valueIsValid()
     * @uses \EnumType\NameMatching::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $nameMatching
     * @return \StructType\CompanyByNameRequest
     */
    public function setNameMatching($nameMatching = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\NameMatching::valueIsValid($nameMatching)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $nameMatching, implode(', ', \EnumType\NameMatching::getValidValues())), __LINE__);
        }
        $this->NameMatching = $nameMatching;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\CompanyByNameRequest
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CompanyByNameRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
