<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CheckCreditLimitForBatchSearch StructType
 * @subpackage Structs
 */
class CheckCreditLimitForBatchSearch extends AbstractStructBase
{
    /**
     * The requestType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $requestType;
    /**
     * The count
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $count;
    /**
     * Constructor method for CheckCreditLimitForBatchSearch
     * @uses CheckCreditLimitForBatchSearch::setRequestType()
     * @uses CheckCreditLimitForBatchSearch::setCount()
     * @param string $requestType
     * @param int $count
     */
    public function __construct($requestType = null, $count = null)
    {
        $this
            ->setRequestType($requestType)
            ->setCount($count);
    }
    /**
     * Get requestType value
     * @return string
     */
    public function getRequestType()
    {
        return $this->requestType;
    }
    /**
     * Set requestType value
     * @uses \EnumType\RequestType::valueIsValid()
     * @uses \EnumType\RequestType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $requestType
     * @return \StructType\CheckCreditLimitForBatchSearch
     */
    public function setRequestType($requestType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\RequestType::valueIsValid($requestType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $requestType, implode(', ', \EnumType\RequestType::getValidValues())), __LINE__);
        }
        $this->requestType = $requestType;
        return $this;
    }
    /**
     * Get count value
     * @return int
     */
    public function getCount()
    {
        return $this->count;
    }
    /**
     * Set count value
     * @param int $count
     * @return \StructType\CheckCreditLimitForBatchSearch
     */
    public function setCount($count = null)
    {
        // validation for constraint: int
        if (!is_null($count) && !is_numeric($count)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($count)), __LINE__);
        }
        $this->count = $count;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CheckCreditLimitForBatchSearch
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
