<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Capital StructType
 * @subpackage Structs
 */
class Capital extends AbstractStructBase
{
    /**
     * The SharesCount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $SharesCount;
    /**
     * The ParriValue
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $ParriValue;
    /**
     * The AmountPerShare
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $AmountPerShare;
    /**
     * The CapitalPremium
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $CapitalPremium;
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CipcLookup
     */
    public $Type;
    /**
     * Constructor method for Capital
     * @uses Capital::setSharesCount()
     * @uses Capital::setParriValue()
     * @uses Capital::setAmountPerShare()
     * @uses Capital::setCapitalPremium()
     * @uses Capital::setType()
     * @param int $sharesCount
     * @param float $parriValue
     * @param float $amountPerShare
     * @param int $capitalPremium
     * @param \StructType\CipcLookup $type
     */
    public function __construct($sharesCount = null, $parriValue = null, $amountPerShare = null, $capitalPremium = null, \StructType\CipcLookup $type = null)
    {
        $this
            ->setSharesCount($sharesCount)
            ->setParriValue($parriValue)
            ->setAmountPerShare($amountPerShare)
            ->setCapitalPremium($capitalPremium)
            ->setType($type);
    }
    /**
     * Get SharesCount value
     * @return int
     */
    public function getSharesCount()
    {
        return $this->SharesCount;
    }
    /**
     * Set SharesCount value
     * @param int $sharesCount
     * @return \StructType\Capital
     */
    public function setSharesCount($sharesCount = null)
    {
        // validation for constraint: int
        if (!is_null($sharesCount) && !is_numeric($sharesCount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sharesCount)), __LINE__);
        }
        $this->SharesCount = $sharesCount;
        return $this;
    }
    /**
     * Get ParriValue value
     * @return float
     */
    public function getParriValue()
    {
        return $this->ParriValue;
    }
    /**
     * Set ParriValue value
     * @param float $parriValue
     * @return \StructType\Capital
     */
    public function setParriValue($parriValue = null)
    {
        $this->ParriValue = $parriValue;
        return $this;
    }
    /**
     * Get AmountPerShare value
     * @return float
     */
    public function getAmountPerShare()
    {
        return $this->AmountPerShare;
    }
    /**
     * Set AmountPerShare value
     * @param float $amountPerShare
     * @return \StructType\Capital
     */
    public function setAmountPerShare($amountPerShare = null)
    {
        $this->AmountPerShare = $amountPerShare;
        return $this;
    }
    /**
     * Get CapitalPremium value
     * @return int
     */
    public function getCapitalPremium()
    {
        return $this->CapitalPremium;
    }
    /**
     * Set CapitalPremium value
     * @param int $capitalPremium
     * @return \StructType\Capital
     */
    public function setCapitalPremium($capitalPremium = null)
    {
        // validation for constraint: int
        if (!is_null($capitalPremium) && !is_numeric($capitalPremium)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($capitalPremium)), __LINE__);
        }
        $this->CapitalPremium = $capitalPremium;
        return $this;
    }
    /**
     * Get Type value
     * @return \StructType\CipcLookup|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param \StructType\CipcLookup $type
     * @return \StructType\Capital
     */
    public function setType(\StructType\CipcLookup $type = null)
    {
        $this->Type = $type;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Capital
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
