<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AssociatedCompany StructType
 * @subpackage Structs
 */
class AssociatedCompany extends AbstractStructBase
{
    /**
     * The DbKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DbKey;
    /**
     * The AppointmentDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $AppointmentDate;
    /**
     * The ResignationDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $ResignationDate;
    /**
     * The ExecutorAppointmentDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $ExecutorAppointmentDate;
    /**
     * The ContributionAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $ContributionAmount;
    /**
     * The ContributionPercentage
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $ContributionPercentage;
    /**
     * The DirectorFormLodgedDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $DirectorFormLodgedDate;
    /**
     * The DirectorFormRecievedDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $DirectorFormRecievedDate;
    /**
     * The FoundingStatementDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $FoundingStatementDate;
    /**
     * The StatusDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $StatusDate;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The RegistrationNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\RegistrationNumber
     */
    public $RegistrationNumber;
    /**
     * The DirectorStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CipcLookup
     */
    public $DirectorStatus;
    /**
     * The DirectorType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CipcLookup
     */
    public $DirectorType;
    /**
     * The Profession
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Profession;
    /**
     * The Executor
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Executor;
    /**
     * The TrusteeName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TrusteeName;
    /**
     * The Estate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Estate;
    /**
     * The Designation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CipcLookup
     */
    public $Designation;
    /**
     * The Occupation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Occupation;
    /**
     * The NatureOfChange
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NatureOfChange;
    /**
     * The ContributionType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ContributionType;
    /**
     * The PostalAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\BasicAddress
     */
    public $PostalAddress;
    /**
     * The ResidentialAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\BasicAddress
     */
    public $ResidentialAddress;
    /**
     * The BusinessAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\BasicAddress
     */
    public $BusinessAddress;
    /**
     * The CompanyStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CipcLookup
     */
    public $CompanyStatus;
    /**
     * Constructor method for AssociatedCompany
     * @uses AssociatedCompany::setDbKey()
     * @uses AssociatedCompany::setAppointmentDate()
     * @uses AssociatedCompany::setResignationDate()
     * @uses AssociatedCompany::setExecutorAppointmentDate()
     * @uses AssociatedCompany::setContributionAmount()
     * @uses AssociatedCompany::setContributionPercentage()
     * @uses AssociatedCompany::setDirectorFormLodgedDate()
     * @uses AssociatedCompany::setDirectorFormRecievedDate()
     * @uses AssociatedCompany::setFoundingStatementDate()
     * @uses AssociatedCompany::setStatusDate()
     * @uses AssociatedCompany::setName()
     * @uses AssociatedCompany::setRegistrationNumber()
     * @uses AssociatedCompany::setDirectorStatus()
     * @uses AssociatedCompany::setDirectorType()
     * @uses AssociatedCompany::setProfession()
     * @uses AssociatedCompany::setExecutor()
     * @uses AssociatedCompany::setTrusteeName()
     * @uses AssociatedCompany::setEstate()
     * @uses AssociatedCompany::setDesignation()
     * @uses AssociatedCompany::setOccupation()
     * @uses AssociatedCompany::setNatureOfChange()
     * @uses AssociatedCompany::setContributionType()
     * @uses AssociatedCompany::setPostalAddress()
     * @uses AssociatedCompany::setResidentialAddress()
     * @uses AssociatedCompany::setBusinessAddress()
     * @uses AssociatedCompany::setCompanyStatus()
     * @param int $dbKey
     * @param string $appointmentDate
     * @param string $resignationDate
     * @param string $executorAppointmentDate
     * @param float $contributionAmount
     * @param float $contributionPercentage
     * @param string $directorFormLodgedDate
     * @param string $directorFormRecievedDate
     * @param string $foundingStatementDate
     * @param string $statusDate
     * @param string $name
     * @param \StructType\RegistrationNumber $registrationNumber
     * @param \StructType\CipcLookup $directorStatus
     * @param \StructType\CipcLookup $directorType
     * @param string $profession
     * @param string $executor
     * @param string $trusteeName
     * @param string $estate
     * @param \StructType\CipcLookup $designation
     * @param string $occupation
     * @param string $natureOfChange
     * @param string $contributionType
     * @param \StructType\BasicAddress $postalAddress
     * @param \StructType\BasicAddress $residentialAddress
     * @param \StructType\BasicAddress $businessAddress
     * @param \StructType\CipcLookup $companyStatus
     */
    public function __construct($dbKey = null, $appointmentDate = null, $resignationDate = null, $executorAppointmentDate = null, $contributionAmount = null, $contributionPercentage = null, $directorFormLodgedDate = null, $directorFormRecievedDate = null, $foundingStatementDate = null, $statusDate = null, $name = null, \StructType\RegistrationNumber $registrationNumber = null, \StructType\CipcLookup $directorStatus = null, \StructType\CipcLookup $directorType = null, $profession = null, $executor = null, $trusteeName = null, $estate = null, \StructType\CipcLookup $designation = null, $occupation = null, $natureOfChange = null, $contributionType = null, \StructType\BasicAddress $postalAddress = null, \StructType\BasicAddress $residentialAddress = null, \StructType\BasicAddress $businessAddress = null, \StructType\CipcLookup $companyStatus = null)
    {
        $this
            ->setDbKey($dbKey)
            ->setAppointmentDate($appointmentDate)
            ->setResignationDate($resignationDate)
            ->setExecutorAppointmentDate($executorAppointmentDate)
            ->setContributionAmount($contributionAmount)
            ->setContributionPercentage($contributionPercentage)
            ->setDirectorFormLodgedDate($directorFormLodgedDate)
            ->setDirectorFormRecievedDate($directorFormRecievedDate)
            ->setFoundingStatementDate($foundingStatementDate)
            ->setStatusDate($statusDate)
            ->setName($name)
            ->setRegistrationNumber($registrationNumber)
            ->setDirectorStatus($directorStatus)
            ->setDirectorType($directorType)
            ->setProfession($profession)
            ->setExecutor($executor)
            ->setTrusteeName($trusteeName)
            ->setEstate($estate)
            ->setDesignation($designation)
            ->setOccupation($occupation)
            ->setNatureOfChange($natureOfChange)
            ->setContributionType($contributionType)
            ->setPostalAddress($postalAddress)
            ->setResidentialAddress($residentialAddress)
            ->setBusinessAddress($businessAddress)
            ->setCompanyStatus($companyStatus);
    }
    /**
     * Get DbKey value
     * @return int
     */
    public function getDbKey()
    {
        return $this->DbKey;
    }
    /**
     * Set DbKey value
     * @param int $dbKey
     * @return \StructType\AssociatedCompany
     */
    public function setDbKey($dbKey = null)
    {
        // validation for constraint: int
        if (!is_null($dbKey) && !is_numeric($dbKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($dbKey)), __LINE__);
        }
        $this->DbKey = $dbKey;
        return $this;
    }
    /**
     * Get AppointmentDate value
     * @return string
     */
    public function getAppointmentDate()
    {
        return $this->AppointmentDate;
    }
    /**
     * Set AppointmentDate value
     * @param string $appointmentDate
     * @return \StructType\AssociatedCompany
     */
    public function setAppointmentDate($appointmentDate = null)
    {
        // validation for constraint: string
        if (!is_null($appointmentDate) && !is_string($appointmentDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($appointmentDate)), __LINE__);
        }
        $this->AppointmentDate = $appointmentDate;
        return $this;
    }
    /**
     * Get ResignationDate value
     * @return string
     */
    public function getResignationDate()
    {
        return $this->ResignationDate;
    }
    /**
     * Set ResignationDate value
     * @param string $resignationDate
     * @return \StructType\AssociatedCompany
     */
    public function setResignationDate($resignationDate = null)
    {
        // validation for constraint: string
        if (!is_null($resignationDate) && !is_string($resignationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($resignationDate)), __LINE__);
        }
        $this->ResignationDate = $resignationDate;
        return $this;
    }
    /**
     * Get ExecutorAppointmentDate value
     * @return string
     */
    public function getExecutorAppointmentDate()
    {
        return $this->ExecutorAppointmentDate;
    }
    /**
     * Set ExecutorAppointmentDate value
     * @param string $executorAppointmentDate
     * @return \StructType\AssociatedCompany
     */
    public function setExecutorAppointmentDate($executorAppointmentDate = null)
    {
        // validation for constraint: string
        if (!is_null($executorAppointmentDate) && !is_string($executorAppointmentDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($executorAppointmentDate)), __LINE__);
        }
        $this->ExecutorAppointmentDate = $executorAppointmentDate;
        return $this;
    }
    /**
     * Get ContributionAmount value
     * @return float
     */
    public function getContributionAmount()
    {
        return $this->ContributionAmount;
    }
    /**
     * Set ContributionAmount value
     * @param float $contributionAmount
     * @return \StructType\AssociatedCompany
     */
    public function setContributionAmount($contributionAmount = null)
    {
        $this->ContributionAmount = $contributionAmount;
        return $this;
    }
    /**
     * Get ContributionPercentage value
     * @return float
     */
    public function getContributionPercentage()
    {
        return $this->ContributionPercentage;
    }
    /**
     * Set ContributionPercentage value
     * @param float $contributionPercentage
     * @return \StructType\AssociatedCompany
     */
    public function setContributionPercentage($contributionPercentage = null)
    {
        $this->ContributionPercentage = $contributionPercentage;
        return $this;
    }
    /**
     * Get DirectorFormLodgedDate value
     * @return string
     */
    public function getDirectorFormLodgedDate()
    {
        return $this->DirectorFormLodgedDate;
    }
    /**
     * Set DirectorFormLodgedDate value
     * @param string $directorFormLodgedDate
     * @return \StructType\AssociatedCompany
     */
    public function setDirectorFormLodgedDate($directorFormLodgedDate = null)
    {
        // validation for constraint: string
        if (!is_null($directorFormLodgedDate) && !is_string($directorFormLodgedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($directorFormLodgedDate)), __LINE__);
        }
        $this->DirectorFormLodgedDate = $directorFormLodgedDate;
        return $this;
    }
    /**
     * Get DirectorFormRecievedDate value
     * @return string
     */
    public function getDirectorFormRecievedDate()
    {
        return $this->DirectorFormRecievedDate;
    }
    /**
     * Set DirectorFormRecievedDate value
     * @param string $directorFormRecievedDate
     * @return \StructType\AssociatedCompany
     */
    public function setDirectorFormRecievedDate($directorFormRecievedDate = null)
    {
        // validation for constraint: string
        if (!is_null($directorFormRecievedDate) && !is_string($directorFormRecievedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($directorFormRecievedDate)), __LINE__);
        }
        $this->DirectorFormRecievedDate = $directorFormRecievedDate;
        return $this;
    }
    /**
     * Get FoundingStatementDate value
     * @return string
     */
    public function getFoundingStatementDate()
    {
        return $this->FoundingStatementDate;
    }
    /**
     * Set FoundingStatementDate value
     * @param string $foundingStatementDate
     * @return \StructType\AssociatedCompany
     */
    public function setFoundingStatementDate($foundingStatementDate = null)
    {
        // validation for constraint: string
        if (!is_null($foundingStatementDate) && !is_string($foundingStatementDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($foundingStatementDate)), __LINE__);
        }
        $this->FoundingStatementDate = $foundingStatementDate;
        return $this;
    }
    /**
     * Get StatusDate value
     * @return string
     */
    public function getStatusDate()
    {
        return $this->StatusDate;
    }
    /**
     * Set StatusDate value
     * @param string $statusDate
     * @return \StructType\AssociatedCompany
     */
    public function setStatusDate($statusDate = null)
    {
        // validation for constraint: string
        if (!is_null($statusDate) && !is_string($statusDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($statusDate)), __LINE__);
        }
        $this->StatusDate = $statusDate;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\AssociatedCompany
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get RegistrationNumber value
     * @return \StructType\RegistrationNumber|null
     */
    public function getRegistrationNumber()
    {
        return $this->RegistrationNumber;
    }
    /**
     * Set RegistrationNumber value
     * @param \StructType\RegistrationNumber $registrationNumber
     * @return \StructType\AssociatedCompany
     */
    public function setRegistrationNumber(\StructType\RegistrationNumber $registrationNumber = null)
    {
        $this->RegistrationNumber = $registrationNumber;
        return $this;
    }
    /**
     * Get DirectorStatus value
     * @return \StructType\CipcLookup|null
     */
    public function getDirectorStatus()
    {
        return $this->DirectorStatus;
    }
    /**
     * Set DirectorStatus value
     * @param \StructType\CipcLookup $directorStatus
     * @return \StructType\AssociatedCompany
     */
    public function setDirectorStatus(\StructType\CipcLookup $directorStatus = null)
    {
        $this->DirectorStatus = $directorStatus;
        return $this;
    }
    /**
     * Get DirectorType value
     * @return \StructType\CipcLookup|null
     */
    public function getDirectorType()
    {
        return $this->DirectorType;
    }
    /**
     * Set DirectorType value
     * @param \StructType\CipcLookup $directorType
     * @return \StructType\AssociatedCompany
     */
    public function setDirectorType(\StructType\CipcLookup $directorType = null)
    {
        $this->DirectorType = $directorType;
        return $this;
    }
    /**
     * Get Profession value
     * @return string|null
     */
    public function getProfession()
    {
        return $this->Profession;
    }
    /**
     * Set Profession value
     * @param string $profession
     * @return \StructType\AssociatedCompany
     */
    public function setProfession($profession = null)
    {
        // validation for constraint: string
        if (!is_null($profession) && !is_string($profession)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($profession)), __LINE__);
        }
        $this->Profession = $profession;
        return $this;
    }
    /**
     * Get Executor value
     * @return string|null
     */
    public function getExecutor()
    {
        return $this->Executor;
    }
    /**
     * Set Executor value
     * @param string $executor
     * @return \StructType\AssociatedCompany
     */
    public function setExecutor($executor = null)
    {
        // validation for constraint: string
        if (!is_null($executor) && !is_string($executor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($executor)), __LINE__);
        }
        $this->Executor = $executor;
        return $this;
    }
    /**
     * Get TrusteeName value
     * @return string|null
     */
    public function getTrusteeName()
    {
        return $this->TrusteeName;
    }
    /**
     * Set TrusteeName value
     * @param string $trusteeName
     * @return \StructType\AssociatedCompany
     */
    public function setTrusteeName($trusteeName = null)
    {
        // validation for constraint: string
        if (!is_null($trusteeName) && !is_string($trusteeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($trusteeName)), __LINE__);
        }
        $this->TrusteeName = $trusteeName;
        return $this;
    }
    /**
     * Get Estate value
     * @return string|null
     */
    public function getEstate()
    {
        return $this->Estate;
    }
    /**
     * Set Estate value
     * @param string $estate
     * @return \StructType\AssociatedCompany
     */
    public function setEstate($estate = null)
    {
        // validation for constraint: string
        if (!is_null($estate) && !is_string($estate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($estate)), __LINE__);
        }
        $this->Estate = $estate;
        return $this;
    }
    /**
     * Get Designation value
     * @return \StructType\CipcLookup|null
     */
    public function getDesignation()
    {
        return $this->Designation;
    }
    /**
     * Set Designation value
     * @param \StructType\CipcLookup $designation
     * @return \StructType\AssociatedCompany
     */
    public function setDesignation(\StructType\CipcLookup $designation = null)
    {
        $this->Designation = $designation;
        return $this;
    }
    /**
     * Get Occupation value
     * @return string|null
     */
    public function getOccupation()
    {
        return $this->Occupation;
    }
    /**
     * Set Occupation value
     * @param string $occupation
     * @return \StructType\AssociatedCompany
     */
    public function setOccupation($occupation = null)
    {
        // validation for constraint: string
        if (!is_null($occupation) && !is_string($occupation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($occupation)), __LINE__);
        }
        $this->Occupation = $occupation;
        return $this;
    }
    /**
     * Get NatureOfChange value
     * @return string|null
     */
    public function getNatureOfChange()
    {
        return $this->NatureOfChange;
    }
    /**
     * Set NatureOfChange value
     * @param string $natureOfChange
     * @return \StructType\AssociatedCompany
     */
    public function setNatureOfChange($natureOfChange = null)
    {
        // validation for constraint: string
        if (!is_null($natureOfChange) && !is_string($natureOfChange)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($natureOfChange)), __LINE__);
        }
        $this->NatureOfChange = $natureOfChange;
        return $this;
    }
    /**
     * Get ContributionType value
     * @return string|null
     */
    public function getContributionType()
    {
        return $this->ContributionType;
    }
    /**
     * Set ContributionType value
     * @param string $contributionType
     * @return \StructType\AssociatedCompany
     */
    public function setContributionType($contributionType = null)
    {
        // validation for constraint: string
        if (!is_null($contributionType) && !is_string($contributionType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($contributionType)), __LINE__);
        }
        $this->ContributionType = $contributionType;
        return $this;
    }
    /**
     * Get PostalAddress value
     * @return \StructType\BasicAddress|null
     */
    public function getPostalAddress()
    {
        return $this->PostalAddress;
    }
    /**
     * Set PostalAddress value
     * @param \StructType\BasicAddress $postalAddress
     * @return \StructType\AssociatedCompany
     */
    public function setPostalAddress(\StructType\BasicAddress $postalAddress = null)
    {
        $this->PostalAddress = $postalAddress;
        return $this;
    }
    /**
     * Get ResidentialAddress value
     * @return \StructType\BasicAddress|null
     */
    public function getResidentialAddress()
    {
        return $this->ResidentialAddress;
    }
    /**
     * Set ResidentialAddress value
     * @param \StructType\BasicAddress $residentialAddress
     * @return \StructType\AssociatedCompany
     */
    public function setResidentialAddress(\StructType\BasicAddress $residentialAddress = null)
    {
        $this->ResidentialAddress = $residentialAddress;
        return $this;
    }
    /**
     * Get BusinessAddress value
     * @return \StructType\BasicAddress|null
     */
    public function getBusinessAddress()
    {
        return $this->BusinessAddress;
    }
    /**
     * Set BusinessAddress value
     * @param \StructType\BasicAddress $businessAddress
     * @return \StructType\AssociatedCompany
     */
    public function setBusinessAddress(\StructType\BasicAddress $businessAddress = null)
    {
        $this->BusinessAddress = $businessAddress;
        return $this;
    }
    /**
     * Get CompanyStatus value
     * @return \StructType\CipcLookup|null
     */
    public function getCompanyStatus()
    {
        return $this->CompanyStatus;
    }
    /**
     * Set CompanyStatus value
     * @param \StructType\CipcLookup $companyStatus
     * @return \StructType\AssociatedCompany
     */
    public function setCompanyStatus(\StructType\CipcLookup $companyStatus = null)
    {
        $this->CompanyStatus = $companyStatus;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AssociatedCompany
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
