<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Password ServiceType
 * @subpackage Services
 */
class Password extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named PasswordActivationKeyIsValid
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PasswordActivationKeyIsValid $parameters
     * @return \StructType\PasswordActivationKeyIsValidResponse|bool
     */
    public function PasswordActivationKeyIsValid(\StructType\PasswordActivationKeyIsValid $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->PasswordActivationKeyIsValid($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\PasswordActivationKeyIsValidResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
