<?php

namespace EnumType;

/**
 * This class stands for NameMatching EnumType
 * @subpackage Enumerations
 */
class NameMatching
{
    /**
     * Constant for value 'Contains'
     * @return string 'Contains'
     */
    const VALUE_CONTAINS = 'Contains';
    /**
     * Constant for value 'Exact'
     * @return string 'Exact'
     */
    const VALUE_EXACT = 'Exact';
    /**
     * Constant for value 'StartsWith'
     * @return string 'StartsWith'
     */
    const VALUE_STARTS_WITH = 'StartsWith';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CONTAINS
     * @uses self::VALUE_EXACT
     * @uses self::VALUE_STARTS_WITH
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CONTAINS,
            self::VALUE_EXACT,
            self::VALUE_STARTS_WITH,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
