<?php

namespace EnumType;

/**
 * This class stands for CreditCheckStatus EnumType
 * @subpackage Enumerations
 */
class CreditCheckStatus
{
    /**
     * Constant for value 'Success'
     * @return string 'Success'
     */
    const VALUE_SUCCESS = 'Success';
    /**
     * Constant for value 'CreditLimitExceeded'
     * @return string 'CreditLimitExceeded'
     */
    const VALUE_CREDIT_LIMIT_EXCEEDED = 'CreditLimitExceeded';
    /**
     * Constant for value 'InsufficientCredit'
     * @return string 'InsufficientCredit'
     */
    const VALUE_INSUFFICIENT_CREDIT = 'InsufficientCredit';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_SUCCESS
     * @uses self::VALUE_CREDIT_LIMIT_EXCEEDED
     * @uses self::VALUE_INSUFFICIENT_CREDIT
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_SUCCESS,
            self::VALUE_CREDIT_LIMIT_EXCEEDED,
            self::VALUE_INSUFFICIENT_CREDIT,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
