<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfCompanyReport ArrayType
 * @subpackage Arrays
 */
class ArrayOfCompanyReport extends AbstractStructArrayBase
{
    /**
     * The CompanyReport
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\CompanyReport[]
     */
    public $CompanyReport;
    /**
     * Constructor method for ArrayOfCompanyReport
     * @uses ArrayOfCompanyReport::setCompanyReport()
     * @param \StructType\CompanyReport[] $companyReport
     */
    public function __construct(array $companyReport = array())
    {
        $this
            ->setCompanyReport($companyReport);
    }
    /**
     * Get CompanyReport value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CompanyReport[]|null
     */
    public function getCompanyReport()
    {
        return isset($this->CompanyReport) ? $this->CompanyReport : null;
    }
    /**
     * Set CompanyReport value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\CompanyReport[] $companyReport
     * @return \ArrayType\ArrayOfCompanyReport
     */
    public function setCompanyReport(array $companyReport = array())
    {
        foreach ($companyReport as $arrayOfCompanyReportCompanyReportItem) {
            // validation for constraint: itemType
            if (!$arrayOfCompanyReportCompanyReportItem instanceof \StructType\CompanyReport) {
                throw new \InvalidArgumentException(sprintf('The CompanyReport property can only contain items of \StructType\CompanyReport, "%s" given', is_object($arrayOfCompanyReportCompanyReportItem) ? get_class($arrayOfCompanyReportCompanyReportItem) : gettype($arrayOfCompanyReportCompanyReportItem)), __LINE__);
            }
        }
        if (is_null($companyReport) || (is_array($companyReport) && empty($companyReport))) {
            unset($this->CompanyReport);
        } else {
            $this->CompanyReport = $companyReport;
        }
        return $this;
    }
    /**
     * Add item to CompanyReport value
     * @throws \InvalidArgumentException
     * @param \StructType\CompanyReport $item
     * @return \ArrayType\ArrayOfCompanyReport
     */
    public function addToCompanyReport(\StructType\CompanyReport $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CompanyReport) {
            throw new \InvalidArgumentException(sprintf('The CompanyReport property can only contain items of \StructType\CompanyReport, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CompanyReport[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\CompanyReport|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\CompanyReport|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\CompanyReport|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\CompanyReport|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\CompanyReport|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string CompanyReport
     */
    public function getAttributeName()
    {
        return 'CompanyReport';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfCompanyReport
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
