<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfAssociatedCompany ArrayType
 * @subpackage Arrays
 */
class ArrayOfAssociatedCompany extends AbstractStructArrayBase
{
    /**
     * The AssociatedCompany
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AssociatedCompany[]
     */
    public $AssociatedCompany;
    /**
     * Constructor method for ArrayOfAssociatedCompany
     * @uses ArrayOfAssociatedCompany::setAssociatedCompany()
     * @param \StructType\AssociatedCompany[] $associatedCompany
     */
    public function __construct(array $associatedCompany = array())
    {
        $this
            ->setAssociatedCompany($associatedCompany);
    }
    /**
     * Get AssociatedCompany value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AssociatedCompany[]|null
     */
    public function getAssociatedCompany()
    {
        return isset($this->AssociatedCompany) ? $this->AssociatedCompany : null;
    }
    /**
     * Set AssociatedCompany value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\AssociatedCompany[] $associatedCompany
     * @return \ArrayType\ArrayOfAssociatedCompany
     */
    public function setAssociatedCompany(array $associatedCompany = array())
    {
        foreach ($associatedCompany as $arrayOfAssociatedCompanyAssociatedCompanyItem) {
            // validation for constraint: itemType
            if (!$arrayOfAssociatedCompanyAssociatedCompanyItem instanceof \StructType\AssociatedCompany) {
                throw new \InvalidArgumentException(sprintf('The AssociatedCompany property can only contain items of \StructType\AssociatedCompany, "%s" given', is_object($arrayOfAssociatedCompanyAssociatedCompanyItem) ? get_class($arrayOfAssociatedCompanyAssociatedCompanyItem) : gettype($arrayOfAssociatedCompanyAssociatedCompanyItem)), __LINE__);
            }
        }
        if (is_null($associatedCompany) || (is_array($associatedCompany) && empty($associatedCompany))) {
            unset($this->AssociatedCompany);
        } else {
            $this->AssociatedCompany = $associatedCompany;
        }
        return $this;
    }
    /**
     * Add item to AssociatedCompany value
     * @throws \InvalidArgumentException
     * @param \StructType\AssociatedCompany $item
     * @return \ArrayType\ArrayOfAssociatedCompany
     */
    public function addToAssociatedCompany(\StructType\AssociatedCompany $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AssociatedCompany) {
            throw new \InvalidArgumentException(sprintf('The AssociatedCompany property can only contain items of \StructType\AssociatedCompany, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->AssociatedCompany[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\AssociatedCompany|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\AssociatedCompany|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\AssociatedCompany|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\AssociatedCompany|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\AssociatedCompany|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string AssociatedCompany
     */
    public function getAttributeName()
    {
        return 'AssociatedCompany';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfAssociatedCompany
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
