<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SmsHistoryRequest StructType
 * @subpackage Structs
 */
class SmsHistoryRequest extends AbstractStructBase
{
    /**
     * The Barcode
     * @var string
     */
    public $Barcode;
    /**
     * The Language
     * Meta informations extracted from the WSDL
     * - default: RUS
     * - minOccurs: 0
     * @var string
     */
    public $Language;
    /**
     * Constructor method for SmsHistoryRequest
     * @uses SmsHistoryRequest::setBarcode()
     * @uses SmsHistoryRequest::setLanguage()
     * @param string $barcode
     * @param string $language
     */
    public function __construct($barcode = null, $language = 'RUS')
    {
        $this
            ->setBarcode($barcode)
            ->setLanguage($language);
    }
    /**
     * Get Barcode value
     * @return string|null
     */
    public function getBarcode()
    {
        return $this->Barcode;
    }
    /**
     * Set Barcode value
     * @param string $barcode
     * @return \StructType\SmsHistoryRequest
     */
    public function setBarcode($barcode = null)
    {
        // validation for constraint: string
        if (!is_null($barcode) && !is_string($barcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($barcode)), __LINE__);
        }
        $this->Barcode = $barcode;
        return $this;
    }
    /**
     * Get Language value
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->Language;
    }
    /**
     * Set Language value
     * @param string $language
     * @return \StructType\SmsHistoryRequest
     */
    public function setLanguage($language = 'RUS')
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($language)), __LINE__);
        }
        $this->Language = $language;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SmsHistoryRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
