<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PostalOrderEventsForMailInput StructType
 * Meta informations extracted from the WSDL
 * - type: tns:PostalOrderEventsForMailInput
 * @subpackage Structs
 */
class PostalOrderEventsForMailInput extends AbstractStructBase
{
    /**
     * The Barcode
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Barcode;
    /**
     * The Language
     * @var string
     */
    public $Language;
    /**
     * Constructor method for PostalOrderEventsForMailInput
     * @uses PostalOrderEventsForMailInput::setBarcode()
     * @uses PostalOrderEventsForMailInput::setLanguage()
     * @param string $barcode
     * @param string $language
     */
    public function __construct($barcode = null, $language = null)
    {
        $this
            ->setBarcode($barcode)
            ->setLanguage($language);
    }
    /**
     * Get Barcode value
     * @return string
     */
    public function getBarcode()
    {
        return $this->Barcode;
    }
    /**
     * Set Barcode value
     * @param string $barcode
     * @return \StructType\PostalOrderEventsForMailInput
     */
    public function setBarcode($barcode = null)
    {
        // validation for constraint: string
        if (!is_null($barcode) && !is_string($barcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($barcode)), __LINE__);
        }
        $this->Barcode = $barcode;
        return $this;
    }
    /**
     * Get Language value
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->Language;
    }
    /**
     * Set Language value
     * @param string $language
     * @return \StructType\PostalOrderEventsForMailInput
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($language)), __LINE__);
        }
        $this->Language = $language;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PostalOrderEventsForMailInput
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
