<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PostalOrderEvent StructType
 * Meta informations extracted from the WSDL
 * - type: tns:PostalOrderEvent
 * @subpackage Structs
 */
class PostalOrderEvent extends AbstractStructBase
{
    /**
     * The Number
     * @var string
     */
    public $Number;
    /**
     * The EventDateTime
     * @var string
     */
    public $EventDateTime;
    /**
     * The EventType
     * @var int
     */
    public $EventType;
    /**
     * The EventName
     * @var string
     */
    public $EventName;
    /**
     * The IndexTo
     * @var int
     */
    public $IndexTo;
    /**
     * The IndexEvent
     * @var int
     */
    public $IndexEvent;
    /**
     * The SumPaymentForward
     * @var int
     */
    public $SumPaymentForward;
    /**
     * The CountryEventCode
     * @var string
     */
    public $CountryEventCode;
    /**
     * The CountryToCode
     * @var string
     */
    public $CountryToCode;
    /**
     * Constructor method for PostalOrderEvent
     * @uses PostalOrderEvent::setNumber()
     * @uses PostalOrderEvent::setEventDateTime()
     * @uses PostalOrderEvent::setEventType()
     * @uses PostalOrderEvent::setEventName()
     * @uses PostalOrderEvent::setIndexTo()
     * @uses PostalOrderEvent::setIndexEvent()
     * @uses PostalOrderEvent::setSumPaymentForward()
     * @uses PostalOrderEvent::setCountryEventCode()
     * @uses PostalOrderEvent::setCountryToCode()
     * @param string $number
     * @param string $eventDateTime
     * @param int $eventType
     * @param string $eventName
     * @param int $indexTo
     * @param int $indexEvent
     * @param int $sumPaymentForward
     * @param string $countryEventCode
     * @param string $countryToCode
     */
    public function __construct($number = null, $eventDateTime = null, $eventType = null, $eventName = null, $indexTo = null, $indexEvent = null, $sumPaymentForward = null, $countryEventCode = null, $countryToCode = null)
    {
        $this
            ->setNumber($number)
            ->setEventDateTime($eventDateTime)
            ->setEventType($eventType)
            ->setEventName($eventName)
            ->setIndexTo($indexTo)
            ->setIndexEvent($indexEvent)
            ->setSumPaymentForward($sumPaymentForward)
            ->setCountryEventCode($countryEventCode)
            ->setCountryToCode($countryToCode);
    }
    /**
     * Get Number value
     * @return string|null
     */
    public function getNumber()
    {
        return $this->Number;
    }
    /**
     * Set Number value
     * @param string $number
     * @return \StructType\PostalOrderEvent
     */
    public function setNumber($number = null)
    {
        // validation for constraint: string
        if (!is_null($number) && !is_string($number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($number)), __LINE__);
        }
        $this->Number = $number;
        return $this;
    }
    /**
     * Get EventDateTime value
     * @return string|null
     */
    public function getEventDateTime()
    {
        return $this->EventDateTime;
    }
    /**
     * Set EventDateTime value
     * @param string $eventDateTime
     * @return \StructType\PostalOrderEvent
     */
    public function setEventDateTime($eventDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($eventDateTime) && !is_string($eventDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($eventDateTime)), __LINE__);
        }
        $this->EventDateTime = $eventDateTime;
        return $this;
    }
    /**
     * Get EventType value
     * @return int|null
     */
    public function getEventType()
    {
        return $this->EventType;
    }
    /**
     * Set EventType value
     * @param int $eventType
     * @return \StructType\PostalOrderEvent
     */
    public function setEventType($eventType = null)
    {
        // validation for constraint: int
        if (!is_null($eventType) && !is_numeric($eventType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($eventType)), __LINE__);
        }
        $this->EventType = $eventType;
        return $this;
    }
    /**
     * Get EventName value
     * @return string|null
     */
    public function getEventName()
    {
        return $this->EventName;
    }
    /**
     * Set EventName value
     * @param string $eventName
     * @return \StructType\PostalOrderEvent
     */
    public function setEventName($eventName = null)
    {
        // validation for constraint: string
        if (!is_null($eventName) && !is_string($eventName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($eventName)), __LINE__);
        }
        $this->EventName = $eventName;
        return $this;
    }
    /**
     * Get IndexTo value
     * @return int|null
     */
    public function getIndexTo()
    {
        return $this->IndexTo;
    }
    /**
     * Set IndexTo value
     * @param int $indexTo
     * @return \StructType\PostalOrderEvent
     */
    public function setIndexTo($indexTo = null)
    {
        // validation for constraint: int
        if (!is_null($indexTo) && !is_numeric($indexTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($indexTo)), __LINE__);
        }
        $this->IndexTo = $indexTo;
        return $this;
    }
    /**
     * Get IndexEvent value
     * @return int|null
     */
    public function getIndexEvent()
    {
        return $this->IndexEvent;
    }
    /**
     * Set IndexEvent value
     * @param int $indexEvent
     * @return \StructType\PostalOrderEvent
     */
    public function setIndexEvent($indexEvent = null)
    {
        // validation for constraint: int
        if (!is_null($indexEvent) && !is_numeric($indexEvent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($indexEvent)), __LINE__);
        }
        $this->IndexEvent = $indexEvent;
        return $this;
    }
    /**
     * Get SumPaymentForward value
     * @return int|null
     */
    public function getSumPaymentForward()
    {
        return $this->SumPaymentForward;
    }
    /**
     * Set SumPaymentForward value
     * @param int $sumPaymentForward
     * @return \StructType\PostalOrderEvent
     */
    public function setSumPaymentForward($sumPaymentForward = null)
    {
        // validation for constraint: int
        if (!is_null($sumPaymentForward) && !is_numeric($sumPaymentForward)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sumPaymentForward)), __LINE__);
        }
        $this->SumPaymentForward = $sumPaymentForward;
        return $this;
    }
    /**
     * Get CountryEventCode value
     * @return string|null
     */
    public function getCountryEventCode()
    {
        return $this->CountryEventCode;
    }
    /**
     * Set CountryEventCode value
     * @param string $countryEventCode
     * @return \StructType\PostalOrderEvent
     */
    public function setCountryEventCode($countryEventCode = null)
    {
        // validation for constraint: string
        if (!is_null($countryEventCode) && !is_string($countryEventCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($countryEventCode)), __LINE__);
        }
        $this->CountryEventCode = $countryEventCode;
        return $this;
    }
    /**
     * Get CountryToCode value
     * @return string|null
     */
    public function getCountryToCode()
    {
        return $this->CountryToCode;
    }
    /**
     * Set CountryToCode value
     * @param string $countryToCode
     * @return \StructType\PostalOrderEvent
     */
    public function setCountryToCode($countryToCode = null)
    {
        // validation for constraint: string
        if (!is_null($countryToCode) && !is_string($countryToCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($countryToCode)), __LINE__);
        }
        $this->CountryToCode = $countryToCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PostalOrderEvent
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
