<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OperationHistoryData StructType
 * @subpackage Structs
 */
class OperationHistoryData extends AbstractStructBase
{
    /**
     * The historyRecord
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\OperationHistoryRecord[]
     */
    public $historyRecord;
    /**
     * Constructor method for OperationHistoryData
     * @uses OperationHistoryData::setHistoryRecord()
     * @param \StructType\OperationHistoryRecord[] $historyRecord
     */
    public function __construct(array $historyRecord = array())
    {
        $this
            ->setHistoryRecord($historyRecord);
    }
    /**
     * Get historyRecord value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\OperationHistoryRecord[]|null
     */
    public function getHistoryRecord()
    {
        return isset($this->historyRecord) ? $this->historyRecord : null;
    }
    /**
     * Set historyRecord value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\OperationHistoryRecord[] $historyRecord
     * @return \StructType\OperationHistoryData
     */
    public function setHistoryRecord(array $historyRecord = array())
    {
        foreach ($historyRecord as $operationHistoryDataHistoryRecordItem) {
            // validation for constraint: itemType
            if (!$operationHistoryDataHistoryRecordItem instanceof \StructType\OperationHistoryRecord) {
                throw new \InvalidArgumentException(sprintf('The historyRecord property can only contain items of \StructType\OperationHistoryRecord, "%s" given', is_object($operationHistoryDataHistoryRecordItem) ? get_class($operationHistoryDataHistoryRecordItem) : gettype($operationHistoryDataHistoryRecordItem)), __LINE__);
            }
        }
        if (is_null($historyRecord) || (is_array($historyRecord) && empty($historyRecord))) {
            unset($this->historyRecord);
        } else {
            $this->historyRecord = $historyRecord;
        }
        return $this;
    }
    /**
     * Add item to historyRecord value
     * @throws \InvalidArgumentException
     * @param \StructType\OperationHistoryRecord $item
     * @return \StructType\OperationHistoryData
     */
    public function addToHistoryRecord(\StructType\OperationHistoryRecord $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OperationHistoryRecord) {
            throw new \InvalidArgumentException(sprintf('The historyRecord property can only contain items of \StructType\OperationHistoryRecord, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->historyRecord[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OperationHistoryData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
