<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LanguageData StructType
 * @subpackage Structs
 */
class LanguageData extends AbstractStructBase
{
    /**
     * The Language
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\Language[]
     */
    public $Language;
    /**
     * Constructor method for LanguageData
     * @uses LanguageData::setLanguage()
     * @param \StructType\Language[] $language
     */
    public function __construct(array $language = array())
    {
        $this
            ->setLanguage($language);
    }
    /**
     * Get Language value
     * @return \StructType\Language[]|null
     */
    public function getLanguage()
    {
        return $this->Language;
    }
    /**
     * Set Language value
     * @throws \InvalidArgumentException
     * @param \StructType\Language[] $language
     * @return \StructType\LanguageData
     */
    public function setLanguage(array $language = array())
    {
        foreach ($language as $languageDataLanguageItem) {
            // validation for constraint: itemType
            if (!$languageDataLanguageItem instanceof \StructType\Language) {
                throw new \InvalidArgumentException(sprintf('The Language property can only contain items of \StructType\Language, "%s" given', is_object($languageDataLanguageItem) ? get_class($languageDataLanguageItem) : gettype($languageDataLanguageItem)), __LINE__);
            }
        }
        $this->Language = $language;
        return $this;
    }
    /**
     * Add item to Language value
     * @throws \InvalidArgumentException
     * @param \StructType\Language $item
     * @return \StructType\LanguageData
     */
    public function addToLanguage(\StructType\Language $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Language) {
            throw new \InvalidArgumentException(sprintf('The Language property can only contain items of \StructType\Language, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Language[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\LanguageData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
