<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ItemParameters StructType
 * @subpackage Structs
 */
class ItemParameters extends AbstractStructBase
{
    /**
     * The Barcode
     * @var string
     */
    public $Barcode;
    /**
     * The Internum
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Internum;
    /**
     * The ValidRuType
     * @var bool
     */
    public $ValidRuType;
    /**
     * The ValidEnType
     * @var bool
     */
    public $ValidEnType;
    /**
     * The ComplexItemName
     * @var string
     */
    public $ComplexItemName;
    /**
     * The MailRank
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Rtm02Parameter
     */
    public $MailRank;
    /**
     * The PostMark
     * @var \StructType\Rtm02Parameter
     */
    public $PostMark;
    /**
     * The MailType
     * @var \StructType\Rtm02Parameter
     */
    public $MailType;
    /**
     * The MailCtg
     * @var \StructType\Rtm02Parameter
     */
    public $MailCtg;
    /**
     * The Mass
     * @var int
     */
    public $Mass;
    /**
     * The MaxMassRU
     * @var int
     */
    public $MaxMassRU;
    /**
     * The MaxMassEN
     * @var int
     */
    public $MaxMassEN;
    /**
     * Constructor method for ItemParameters
     * @uses ItemParameters::setBarcode()
     * @uses ItemParameters::setInternum()
     * @uses ItemParameters::setValidRuType()
     * @uses ItemParameters::setValidEnType()
     * @uses ItemParameters::setComplexItemName()
     * @uses ItemParameters::setMailRank()
     * @uses ItemParameters::setPostMark()
     * @uses ItemParameters::setMailType()
     * @uses ItemParameters::setMailCtg()
     * @uses ItemParameters::setMass()
     * @uses ItemParameters::setMaxMassRU()
     * @uses ItemParameters::setMaxMassEN()
     * @param string $barcode
     * @param string $internum
     * @param bool $validRuType
     * @param bool $validEnType
     * @param string $complexItemName
     * @param \StructType\Rtm02Parameter $mailRank
     * @param \StructType\Rtm02Parameter $postMark
     * @param \StructType\Rtm02Parameter $mailType
     * @param \StructType\Rtm02Parameter $mailCtg
     * @param int $mass
     * @param int $maxMassRU
     * @param int $maxMassEN
     */
    public function __construct($barcode = null, $internum = null, $validRuType = null, $validEnType = null, $complexItemName = null, \StructType\Rtm02Parameter $mailRank = null, \StructType\Rtm02Parameter $postMark = null, \StructType\Rtm02Parameter $mailType = null, \StructType\Rtm02Parameter $mailCtg = null, $mass = null, $maxMassRU = null, $maxMassEN = null)
    {
        $this
            ->setBarcode($barcode)
            ->setInternum($internum)
            ->setValidRuType($validRuType)
            ->setValidEnType($validEnType)
            ->setComplexItemName($complexItemName)
            ->setMailRank($mailRank)
            ->setPostMark($postMark)
            ->setMailType($mailType)
            ->setMailCtg($mailCtg)
            ->setMass($mass)
            ->setMaxMassRU($maxMassRU)
            ->setMaxMassEN($maxMassEN);
    }
    /**
     * Get Barcode value
     * @return string|null
     */
    public function getBarcode()
    {
        return $this->Barcode;
    }
    /**
     * Set Barcode value
     * @param string $barcode
     * @return \StructType\ItemParameters
     */
    public function setBarcode($barcode = null)
    {
        // validation for constraint: string
        if (!is_null($barcode) && !is_string($barcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($barcode)), __LINE__);
        }
        $this->Barcode = $barcode;
        return $this;
    }
    /**
     * Get Internum value
     * @return string|null
     */
    public function getInternum()
    {
        return $this->Internum;
    }
    /**
     * Set Internum value
     * @param string $internum
     * @return \StructType\ItemParameters
     */
    public function setInternum($internum = null)
    {
        // validation for constraint: string
        if (!is_null($internum) && !is_string($internum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($internum)), __LINE__);
        }
        $this->Internum = $internum;
        return $this;
    }
    /**
     * Get ValidRuType value
     * @return bool|null
     */
    public function getValidRuType()
    {
        return $this->ValidRuType;
    }
    /**
     * Set ValidRuType value
     * @param bool $validRuType
     * @return \StructType\ItemParameters
     */
    public function setValidRuType($validRuType = null)
    {
        // validation for constraint: boolean
        if (!is_null($validRuType) && !is_bool($validRuType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($validRuType)), __LINE__);
        }
        $this->ValidRuType = $validRuType;
        return $this;
    }
    /**
     * Get ValidEnType value
     * @return bool|null
     */
    public function getValidEnType()
    {
        return $this->ValidEnType;
    }
    /**
     * Set ValidEnType value
     * @param bool $validEnType
     * @return \StructType\ItemParameters
     */
    public function setValidEnType($validEnType = null)
    {
        // validation for constraint: boolean
        if (!is_null($validEnType) && !is_bool($validEnType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($validEnType)), __LINE__);
        }
        $this->ValidEnType = $validEnType;
        return $this;
    }
    /**
     * Get ComplexItemName value
     * @return string|null
     */
    public function getComplexItemName()
    {
        return $this->ComplexItemName;
    }
    /**
     * Set ComplexItemName value
     * @param string $complexItemName
     * @return \StructType\ItemParameters
     */
    public function setComplexItemName($complexItemName = null)
    {
        // validation for constraint: string
        if (!is_null($complexItemName) && !is_string($complexItemName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($complexItemName)), __LINE__);
        }
        $this->ComplexItemName = $complexItemName;
        return $this;
    }
    /**
     * Get MailRank value
     * @return \StructType\Rtm02Parameter|null
     */
    public function getMailRank()
    {
        return $this->MailRank;
    }
    /**
     * Set MailRank value
     * @param \StructType\Rtm02Parameter $mailRank
     * @return \StructType\ItemParameters
     */
    public function setMailRank(\StructType\Rtm02Parameter $mailRank = null)
    {
        $this->MailRank = $mailRank;
        return $this;
    }
    /**
     * Get PostMark value
     * @return \StructType\Rtm02Parameter|null
     */
    public function getPostMark()
    {
        return $this->PostMark;
    }
    /**
     * Set PostMark value
     * @param \StructType\Rtm02Parameter $postMark
     * @return \StructType\ItemParameters
     */
    public function setPostMark(\StructType\Rtm02Parameter $postMark = null)
    {
        $this->PostMark = $postMark;
        return $this;
    }
    /**
     * Get MailType value
     * @return \StructType\Rtm02Parameter|null
     */
    public function getMailType()
    {
        return $this->MailType;
    }
    /**
     * Set MailType value
     * @param \StructType\Rtm02Parameter $mailType
     * @return \StructType\ItemParameters
     */
    public function setMailType(\StructType\Rtm02Parameter $mailType = null)
    {
        $this->MailType = $mailType;
        return $this;
    }
    /**
     * Get MailCtg value
     * @return \StructType\Rtm02Parameter|null
     */
    public function getMailCtg()
    {
        return $this->MailCtg;
    }
    /**
     * Set MailCtg value
     * @param \StructType\Rtm02Parameter $mailCtg
     * @return \StructType\ItemParameters
     */
    public function setMailCtg(\StructType\Rtm02Parameter $mailCtg = null)
    {
        $this->MailCtg = $mailCtg;
        return $this;
    }
    /**
     * Get Mass value
     * @return int|null
     */
    public function getMass()
    {
        return $this->Mass;
    }
    /**
     * Set Mass value
     * @param int $mass
     * @return \StructType\ItemParameters
     */
    public function setMass($mass = null)
    {
        // validation for constraint: int
        if (!is_null($mass) && !is_numeric($mass)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($mass)), __LINE__);
        }
        $this->Mass = $mass;
        return $this;
    }
    /**
     * Get MaxMassRU value
     * @return int|null
     */
    public function getMaxMassRU()
    {
        return $this->MaxMassRU;
    }
    /**
     * Set MaxMassRU value
     * @param int $maxMassRU
     * @return \StructType\ItemParameters
     */
    public function setMaxMassRU($maxMassRU = null)
    {
        // validation for constraint: int
        if (!is_null($maxMassRU) && !is_numeric($maxMassRU)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($maxMassRU)), __LINE__);
        }
        $this->MaxMassRU = $maxMassRU;
        return $this;
    }
    /**
     * Get MaxMassEN value
     * @return int|null
     */
    public function getMaxMassEN()
    {
        return $this->MaxMassEN;
    }
    /**
     * Set MaxMassEN value
     * @param int $maxMassEN
     * @return \StructType\ItemParameters
     */
    public function setMaxMassEN($maxMassEN = null)
    {
        // validation for constraint: int
        if (!is_null($maxMassEN) && !is_numeric($maxMassEN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($maxMassEN)), __LINE__);
        }
        $this->MaxMassEN = $maxMassEN;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ItemParameters
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
