<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AuthorizationHeader StructType
 * @subpackage Structs
 */
class AuthorizationHeader extends AbstractStructBase
{
    /**
     * The login
     * @var string
     */
    public $login;
    /**
     * The password
     * @var string
     */
    public $password;
    /**
     * The mustUnderstand
     * Meta informations extracted from the WSDL
     * - ref: ns1:mustUnderstand
     * @var string
     */
    public $mustUnderstand;
    /**
     * Constructor method for AuthorizationHeader
     * @uses AuthorizationHeader::setLogin()
     * @uses AuthorizationHeader::setPassword()
     * @uses AuthorizationHeader::setMustUnderstand()
     * @param string $login
     * @param string $password
     * @param string $mustUnderstand
     */
    public function __construct($login = null, $password = null, $mustUnderstand = null)
    {
        $this
            ->setLogin($login)
            ->setPassword($password)
            ->setMustUnderstand($mustUnderstand);
    }
    /**
     * Get login value
     * @return string|null
     */
    public function getLogin()
    {
        return $this->login;
    }
    /**
     * Set login value
     * @param string $login
     * @return \StructType\AuthorizationHeader
     */
    public function setLogin($login = null)
    {
        // validation for constraint: string
        if (!is_null($login) && !is_string($login)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($login)), __LINE__);
        }
        $this->login = $login;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \StructType\AuthorizationHeader
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get mustUnderstand value
     * @return string|null
     */
    public function getMustUnderstand()
    {
        return $this->mustUnderstand;
    }
    /**
     * Set mustUnderstand value
     * @param string $mustUnderstand
     * @return \StructType\AuthorizationHeader
     */
    public function setMustUnderstand($mustUnderstand = null)
    {
        // validation for constraint: string
        if (!is_null($mustUnderstand) && !is_string($mustUnderstand)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mustUnderstand)), __LINE__);
        }
        $this->mustUnderstand = $mustUnderstand;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AuthorizationHeader
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
