<?php

namespace EnumType;

/**
 * This class stands for PostalOrderEventsForMailErrors EnumType
 * @subpackage Enumerations
 */
class PostalOrderEventsForMailErrors
{
    /**
     * Constant for value 'InvalidLoginOrPassword'
     * @return string 'InvalidLoginOrPassword'
     */
    const VALUE_INVALID_LOGIN_OR_PASSWORD = 'InvalidLoginOrPassword';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_INVALID_LOGIN_OR_PASSWORD
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_INVALID_LOGIN_OR_PASSWORD,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
