<?php

namespace EnumType;

/**
 * This class stands for CustomDutyEventsForMailErrors EnumType
 * @subpackage Enumerations
 */
class CustomDutyEventsForMailErrors
{
    /**
     * Constant for value 'BarcodeIsNull'
     * @return string 'BarcodeIsNull'
     */
    const VALUE_BARCODE_IS_NULL = 'BarcodeIsNull';
    /**
     * Constant for value 'InternalServiceError'
     * @return string 'InternalServiceError'
     */
    const VALUE_INTERNAL_SERVICE_ERROR = 'InternalServiceError';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_BARCODE_IS_NULL
     * @uses self::VALUE_INTERNAL_SERVICE_ERROR
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_BARCODE_IS_NULL,
            self::VALUE_INTERNAL_SERVICE_ERROR,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
