<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Country StructType
 * @subpackage Structs
 */
class Country extends AbstractStructBase
{
    /**
     * The Id
     * @var int
     */
    public $Id;
    /**
     * The Code2A
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Code2A;
    /**
     * The Code3A
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Code3A;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The NameRU
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $NameRU;
    /**
     * The NameEN
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $NameEN;
    /**
     * Constructor method for Country
     * @uses Country::setId()
     * @uses Country::setCode2A()
     * @uses Country::setCode3A()
     * @uses Country::setName()
     * @uses Country::setNameRU()
     * @uses Country::setNameEN()
     * @param int $id
     * @param string $code2A
     * @param string $code3A
     * @param string $name
     * @param string $nameRU
     * @param string $nameEN
     */
    public function __construct($id = null, $code2A = null, $code3A = null, $name = null, $nameRU = null, $nameEN = null)
    {
        $this
            ->setId($id)
            ->setCode2A($code2A)
            ->setCode3A($code3A)
            ->setName($name)
            ->setNameRU($nameRU)
            ->setNameEN($nameEN);
    }
    /**
     * Get Id value
     * @return int|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param int $id
     * @return \StructType\Country
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !is_numeric($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get Code2A value
     * @return string|null
     */
    public function getCode2A()
    {
        return $this->Code2A;
    }
    /**
     * Set Code2A value
     * @param string $code2A
     * @return \StructType\Country
     */
    public function setCode2A($code2A = null)
    {
        // validation for constraint: string
        if (!is_null($code2A) && !is_string($code2A)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($code2A)), __LINE__);
        }
        $this->Code2A = $code2A;
        return $this;
    }
    /**
     * Get Code3A value
     * @return string|null
     */
    public function getCode3A()
    {
        return $this->Code3A;
    }
    /**
     * Set Code3A value
     * @param string $code3A
     * @return \StructType\Country
     */
    public function setCode3A($code3A = null)
    {
        // validation for constraint: string
        if (!is_null($code3A) && !is_string($code3A)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($code3A)), __LINE__);
        }
        $this->Code3A = $code3A;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\Country
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get NameRU value
     * @return string|null
     */
    public function getNameRU()
    {
        return $this->NameRU;
    }
    /**
     * Set NameRU value
     * @param string $nameRU
     * @return \StructType\Country
     */
    public function setNameRU($nameRU = null)
    {
        // validation for constraint: string
        if (!is_null($nameRU) && !is_string($nameRU)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nameRU)), __LINE__);
        }
        $this->NameRU = $nameRU;
        return $this;
    }
    /**
     * Get NameEN value
     * @return string|null
     */
    public function getNameEN()
    {
        return $this->NameEN;
    }
    /**
     * Set NameEN value
     * @param string $nameEN
     * @return \StructType\Country
     */
    public function setNameEN($nameEN = null)
    {
        // validation for constraint: string
        if (!is_null($nameEN) && !is_string($nameEN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nameEN)), __LINE__);
        }
        $this->NameEN = $nameEN;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Country
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
