<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named getOperationHistory
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetOperationHistory $parameters
     * @return \StructType\GetOperationHistoryResponse|bool
     */
    public function getOperationHistory(\StructType\GetOperationHistory $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getOperationHistory($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getLanguages
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetLanguages $parameters
     * @return \StructType\GetLanguagesResponse|bool
     */
    public function getLanguages(\StructType\GetLanguages $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getLanguages($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCustomDutyEventsForMail
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCustomDutyEventsForMail $parameters
     * @return \StructType\GetCustomDutyEventsForMailResponse|bool
     */
    public function getCustomDutyEventsForMail(\StructType\GetCustomDutyEventsForMail $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getCustomDutyEventsForMail($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getSmsHistory
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetSmsHistory $parameters
     * @return \StructType\GetSmsHistoryResponse|bool
     */
    public function getSmsHistory(\StructType\GetSmsHistory $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getSmsHistory($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GetCustomDutyEventsForMailResponse|\StructType\GetLanguagesResponse|\StructType\GetOperationHistoryResponse|\StructType\GetSmsHistoryResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
