<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateOperationRequest StructType
 * Meta informations extracted from the WSDL
 * - type: tns:UpdateOperationRequest
 * @subpackage Structs
 */
class UpdateOperationRequest extends AbstractStructBase
{
    /**
     * The RequestType
     * @var string
     */
    public $RequestType;
    /**
     * The SourceOperation
     * @var \StructType\OperationHistoryRecord
     */
    public $SourceOperation;
    /**
     * The TargetOperation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\OperationHistoryRecord
     */
    public $TargetOperation;
    /**
     * The ReasonDescription
     * @var string
     */
    public $ReasonDescription;
    /**
     * The InitiatorDepartment
     * @var int
     */
    public $InitiatorDepartment;
    /**
     * The ExecutorIP
     * @var string
     */
    public $ExecutorIP;
    /**
     * Constructor method for UpdateOperationRequest
     * @uses UpdateOperationRequest::setRequestType()
     * @uses UpdateOperationRequest::setSourceOperation()
     * @uses UpdateOperationRequest::setTargetOperation()
     * @uses UpdateOperationRequest::setReasonDescription()
     * @uses UpdateOperationRequest::setInitiatorDepartment()
     * @uses UpdateOperationRequest::setExecutorIP()
     * @param string $requestType
     * @param \StructType\OperationHistoryRecord $sourceOperation
     * @param \StructType\OperationHistoryRecord $targetOperation
     * @param string $reasonDescription
     * @param int $initiatorDepartment
     * @param string $executorIP
     */
    public function __construct($requestType = null, \StructType\OperationHistoryRecord $sourceOperation = null, \StructType\OperationHistoryRecord $targetOperation = null, $reasonDescription = null, $initiatorDepartment = null, $executorIP = null)
    {
        $this
            ->setRequestType($requestType)
            ->setSourceOperation($sourceOperation)
            ->setTargetOperation($targetOperation)
            ->setReasonDescription($reasonDescription)
            ->setInitiatorDepartment($initiatorDepartment)
            ->setExecutorIP($executorIP);
    }
    /**
     * Get RequestType value
     * @return string|null
     */
    public function getRequestType()
    {
        return $this->RequestType;
    }
    /**
     * Set RequestType value
     * @uses \EnumType\RequestType::valueIsValid()
     * @uses \EnumType\RequestType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $requestType
     * @return \StructType\UpdateOperationRequest
     */
    public function setRequestType($requestType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\RequestType::valueIsValid($requestType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $requestType, implode(', ', \EnumType\RequestType::getValidValues())), __LINE__);
        }
        $this->RequestType = $requestType;
        return $this;
    }
    /**
     * Get SourceOperation value
     * @return \StructType\OperationHistoryRecord|null
     */
    public function getSourceOperation()
    {
        return $this->SourceOperation;
    }
    /**
     * Set SourceOperation value
     * @param \StructType\OperationHistoryRecord $sourceOperation
     * @return \StructType\UpdateOperationRequest
     */
    public function setSourceOperation(\StructType\OperationHistoryRecord $sourceOperation = null)
    {
        $this->SourceOperation = $sourceOperation;
        return $this;
    }
    /**
     * Get TargetOperation value
     * @return \StructType\OperationHistoryRecord|null
     */
    public function getTargetOperation()
    {
        return $this->TargetOperation;
    }
    /**
     * Set TargetOperation value
     * @param \StructType\OperationHistoryRecord $targetOperation
     * @return \StructType\UpdateOperationRequest
     */
    public function setTargetOperation(\StructType\OperationHistoryRecord $targetOperation = null)
    {
        $this->TargetOperation = $targetOperation;
        return $this;
    }
    /**
     * Get ReasonDescription value
     * @return string|null
     */
    public function getReasonDescription()
    {
        return $this->ReasonDescription;
    }
    /**
     * Set ReasonDescription value
     * @param string $reasonDescription
     * @return \StructType\UpdateOperationRequest
     */
    public function setReasonDescription($reasonDescription = null)
    {
        // validation for constraint: string
        if (!is_null($reasonDescription) && !is_string($reasonDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($reasonDescription)), __LINE__);
        }
        $this->ReasonDescription = $reasonDescription;
        return $this;
    }
    /**
     * Get InitiatorDepartment value
     * @return int|null
     */
    public function getInitiatorDepartment()
    {
        return $this->InitiatorDepartment;
    }
    /**
     * Set InitiatorDepartment value
     * @param int $initiatorDepartment
     * @return \StructType\UpdateOperationRequest
     */
    public function setInitiatorDepartment($initiatorDepartment = null)
    {
        // validation for constraint: int
        if (!is_null($initiatorDepartment) && !is_numeric($initiatorDepartment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($initiatorDepartment)), __LINE__);
        }
        $this->InitiatorDepartment = $initiatorDepartment;
        return $this;
    }
    /**
     * Get ExecutorIP value
     * @return string|null
     */
    public function getExecutorIP()
    {
        return $this->ExecutorIP;
    }
    /**
     * Set ExecutorIP value
     * @param string $executorIP
     * @return \StructType\UpdateOperationRequest
     */
    public function setExecutorIP($executorIP = null)
    {
        // validation for constraint: string
        if (!is_null($executorIP) && !is_string($executorIP)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($executorIP)), __LINE__);
        }
        $this->ExecutorIP = $executorIP;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UpdateOperationRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
