<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SmsHistoryData StructType
 * @subpackage Structs
 */
class SmsHistoryData extends AbstractStructBase
{
    /**
     * The historyRecord
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\SmsHistoryRecord[]
     */
    public $historyRecord;
    /**
     * Constructor method for SmsHistoryData
     * @uses SmsHistoryData::setHistoryRecord()
     * @param \StructType\SmsHistoryRecord[] $historyRecord
     */
    public function __construct(array $historyRecord = array())
    {
        $this
            ->setHistoryRecord($historyRecord);
    }
    /**
     * Get historyRecord value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\SmsHistoryRecord[]|null
     */
    public function getHistoryRecord()
    {
        return isset($this->historyRecord) ? $this->historyRecord : null;
    }
    /**
     * Set historyRecord value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\SmsHistoryRecord[] $historyRecord
     * @return \StructType\SmsHistoryData
     */
    public function setHistoryRecord(array $historyRecord = array())
    {
        foreach ($historyRecord as $smsHistoryDataHistoryRecordItem) {
            // validation for constraint: itemType
            if (!$smsHistoryDataHistoryRecordItem instanceof \StructType\SmsHistoryRecord) {
                throw new \InvalidArgumentException(sprintf('The historyRecord property can only contain items of \StructType\SmsHistoryRecord, "%s" given', is_object($smsHistoryDataHistoryRecordItem) ? get_class($smsHistoryDataHistoryRecordItem) : gettype($smsHistoryDataHistoryRecordItem)), __LINE__);
            }
        }
        if (is_null($historyRecord) || (is_array($historyRecord) && empty($historyRecord))) {
            unset($this->historyRecord);
        } else {
            $this->historyRecord = $historyRecord;
        }
        return $this;
    }
    /**
     * Add item to historyRecord value
     * @throws \InvalidArgumentException
     * @param \StructType\SmsHistoryRecord $item
     * @return \StructType\SmsHistoryData
     */
    public function addToHistoryRecord(\StructType\SmsHistoryRecord $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SmsHistoryRecord) {
            throw new \InvalidArgumentException(sprintf('The historyRecord property can only contain items of \StructType\SmsHistoryRecord, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->historyRecord[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SmsHistoryData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
