<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PostalOrderEventsForMailError StructType
 * Meta informations extracted from the WSDL
 * - type: tns:PostalOrderEventsForMailError
 * @subpackage Structs
 */
class PostalOrderEventsForMailError extends AbstractStructBase
{
    /**
     * The ErrorID
     * @var string
     */
    public $ErrorID;
    /**
     * Constructor method for PostalOrderEventsForMailError
     * @uses PostalOrderEventsForMailError::setErrorID()
     * @param string $errorID
     */
    public function __construct($errorID = null)
    {
        $this
            ->setErrorID($errorID);
    }
    /**
     * Get ErrorID value
     * @return string|null
     */
    public function getErrorID()
    {
        return $this->ErrorID;
    }
    /**
     * Set ErrorID value
     * @uses \EnumType\PostalOrderEventsForMailErrors::valueIsValid()
     * @uses \EnumType\PostalOrderEventsForMailErrors::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $errorID
     * @return \StructType\PostalOrderEventsForMailError
     */
    public function setErrorID($errorID = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PostalOrderEventsForMailErrors::valueIsValid($errorID)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $errorID, implode(', ', \EnumType\PostalOrderEventsForMailErrors::getValidValues())), __LINE__);
        }
        $this->ErrorID = $errorID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PostalOrderEventsForMailError
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
