<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OperationParameters StructType
 * @subpackage Structs
 */
class OperationParameters extends AbstractStructBase
{
    /**
     * The OperType
     * @var \StructType\Rtm02Parameter
     */
    public $OperType;
    /**
     * The OperAttr
     * @var \StructType\Rtm02Parameter
     */
    public $OperAttr;
    /**
     * The OperDate
     * @var string
     */
    public $OperDate;
    /**
     * Constructor method for OperationParameters
     * @uses OperationParameters::setOperType()
     * @uses OperationParameters::setOperAttr()
     * @uses OperationParameters::setOperDate()
     * @param \StructType\Rtm02Parameter $operType
     * @param \StructType\Rtm02Parameter $operAttr
     * @param string $operDate
     */
    public function __construct(\StructType\Rtm02Parameter $operType = null, \StructType\Rtm02Parameter $operAttr = null, $operDate = null)
    {
        $this
            ->setOperType($operType)
            ->setOperAttr($operAttr)
            ->setOperDate($operDate);
    }
    /**
     * Get OperType value
     * @return \StructType\Rtm02Parameter|null
     */
    public function getOperType()
    {
        return $this->OperType;
    }
    /**
     * Set OperType value
     * @param \StructType\Rtm02Parameter $operType
     * @return \StructType\OperationParameters
     */
    public function setOperType(\StructType\Rtm02Parameter $operType = null)
    {
        $this->OperType = $operType;
        return $this;
    }
    /**
     * Get OperAttr value
     * @return \StructType\Rtm02Parameter|null
     */
    public function getOperAttr()
    {
        return $this->OperAttr;
    }
    /**
     * Set OperAttr value
     * @param \StructType\Rtm02Parameter $operAttr
     * @return \StructType\OperationParameters
     */
    public function setOperAttr(\StructType\Rtm02Parameter $operAttr = null)
    {
        $this->OperAttr = $operAttr;
        return $this;
    }
    /**
     * Get OperDate value
     * @return string|null
     */
    public function getOperDate()
    {
        return $this->OperDate;
    }
    /**
     * Set OperDate value
     * @param string $operDate
     * @return \StructType\OperationParameters
     */
    public function setOperDate($operDate = null)
    {
        // validation for constraint: string
        if (!is_null($operDate) && !is_string($operDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($operDate)), __LINE__);
        }
        $this->OperDate = $operDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OperationParameters
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
