<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OperationHistoryRequest StructType
 * @subpackage Structs
 */
class OperationHistoryRequest extends AbstractStructBase
{
    /**
     * The Barcode
     * @var string
     */
    public $Barcode;
    /**
     * The MessageType
     * @var int
     */
    public $MessageType;
    /**
     * The Language
     * Meta informations extracted from the WSDL
     * - default: RUS
     * - minOccurs: 0
     * @var string
     */
    public $Language;
    /**
     * Constructor method for OperationHistoryRequest
     * @uses OperationHistoryRequest::setBarcode()
     * @uses OperationHistoryRequest::setMessageType()
     * @uses OperationHistoryRequest::setLanguage()
     * @param string $barcode
     * @param int $messageType
     * @param string $language
     */
    public function __construct($barcode = null, $messageType = null, $language = 'RUS')
    {
        $this
            ->setBarcode($barcode)
            ->setMessageType($messageType)
            ->setLanguage($language);
    }
    /**
     * Get Barcode value
     * @return string|null
     */
    public function getBarcode()
    {
        return $this->Barcode;
    }
    /**
     * Set Barcode value
     * @param string $barcode
     * @return \StructType\OperationHistoryRequest
     */
    public function setBarcode($barcode = null)
    {
        // validation for constraint: string
        if (!is_null($barcode) && !is_string($barcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($barcode)), __LINE__);
        }
        $this->Barcode = $barcode;
        return $this;
    }
    /**
     * Get MessageType value
     * @return int|null
     */
    public function getMessageType()
    {
        return $this->MessageType;
    }
    /**
     * Set MessageType value
     * @param int $messageType
     * @return \StructType\OperationHistoryRequest
     */
    public function setMessageType($messageType = null)
    {
        // validation for constraint: int
        if (!is_null($messageType) && !is_numeric($messageType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($messageType)), __LINE__);
        }
        $this->MessageType = $messageType;
        return $this;
    }
    /**
     * Get Language value
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->Language;
    }
    /**
     * Set Language value
     * @param string $language
     * @return \StructType\OperationHistoryRequest
     */
    public function setLanguage($language = 'RUS')
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($language)), __LINE__);
        }
        $this->Language = $language;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OperationHistoryRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
