<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OperationHistoryRecord StructType
 * @subpackage Structs
 */
class OperationHistoryRecord extends AbstractStructBase
{
    /**
     * The AddressParameters
     * @var \StructType\AddressParameters
     */
    public $AddressParameters;
    /**
     * The FinanceParameters
     * @var \StructType\FinanceParameters
     */
    public $FinanceParameters;
    /**
     * The ItemParameters
     * @var \StructType\ItemParameters
     */
    public $ItemParameters;
    /**
     * The OperationParameters
     * @var \StructType\OperationParameters
     */
    public $OperationParameters;
    /**
     * The UserParameters
     * @var \StructType\UserParameters
     */
    public $UserParameters;
    /**
     * Constructor method for OperationHistoryRecord
     * @uses OperationHistoryRecord::setAddressParameters()
     * @uses OperationHistoryRecord::setFinanceParameters()
     * @uses OperationHistoryRecord::setItemParameters()
     * @uses OperationHistoryRecord::setOperationParameters()
     * @uses OperationHistoryRecord::setUserParameters()
     * @param \StructType\AddressParameters $addressParameters
     * @param \StructType\FinanceParameters $financeParameters
     * @param \StructType\ItemParameters $itemParameters
     * @param \StructType\OperationParameters $operationParameters
     * @param \StructType\UserParameters $userParameters
     */
    public function __construct(\StructType\AddressParameters $addressParameters = null, \StructType\FinanceParameters $financeParameters = null, \StructType\ItemParameters $itemParameters = null, \StructType\OperationParameters $operationParameters = null, \StructType\UserParameters $userParameters = null)
    {
        $this
            ->setAddressParameters($addressParameters)
            ->setFinanceParameters($financeParameters)
            ->setItemParameters($itemParameters)
            ->setOperationParameters($operationParameters)
            ->setUserParameters($userParameters);
    }
    /**
     * Get AddressParameters value
     * @return \StructType\AddressParameters|null
     */
    public function getAddressParameters()
    {
        return $this->AddressParameters;
    }
    /**
     * Set AddressParameters value
     * @param \StructType\AddressParameters $addressParameters
     * @return \StructType\OperationHistoryRecord
     */
    public function setAddressParameters(\StructType\AddressParameters $addressParameters = null)
    {
        $this->AddressParameters = $addressParameters;
        return $this;
    }
    /**
     * Get FinanceParameters value
     * @return \StructType\FinanceParameters|null
     */
    public function getFinanceParameters()
    {
        return $this->FinanceParameters;
    }
    /**
     * Set FinanceParameters value
     * @param \StructType\FinanceParameters $financeParameters
     * @return \StructType\OperationHistoryRecord
     */
    public function setFinanceParameters(\StructType\FinanceParameters $financeParameters = null)
    {
        $this->FinanceParameters = $financeParameters;
        return $this;
    }
    /**
     * Get ItemParameters value
     * @return \StructType\ItemParameters|null
     */
    public function getItemParameters()
    {
        return $this->ItemParameters;
    }
    /**
     * Set ItemParameters value
     * @param \StructType\ItemParameters $itemParameters
     * @return \StructType\OperationHistoryRecord
     */
    public function setItemParameters(\StructType\ItemParameters $itemParameters = null)
    {
        $this->ItemParameters = $itemParameters;
        return $this;
    }
    /**
     * Get OperationParameters value
     * @return \StructType\OperationParameters|null
     */
    public function getOperationParameters()
    {
        return $this->OperationParameters;
    }
    /**
     * Set OperationParameters value
     * @param \StructType\OperationParameters $operationParameters
     * @return \StructType\OperationHistoryRecord
     */
    public function setOperationParameters(\StructType\OperationParameters $operationParameters = null)
    {
        $this->OperationParameters = $operationParameters;
        return $this;
    }
    /**
     * Get UserParameters value
     * @return \StructType\UserParameters|null
     */
    public function getUserParameters()
    {
        return $this->UserParameters;
    }
    /**
     * Set UserParameters value
     * @param \StructType\UserParameters $userParameters
     * @return \StructType\OperationHistoryRecord
     */
    public function setUserParameters(\StructType\UserParameters $userParameters = null)
    {
        $this->UserParameters = $userParameters;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OperationHistoryRecord
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
