<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FinanceParameters StructType
 * @subpackage Structs
 */
class FinanceParameters extends AbstractStructBase
{
    /**
     * The Payment
     * @var int
     */
    public $Payment;
    /**
     * The Value
     * @var int
     */
    public $Value;
    /**
     * The MassRate
     * @var int
     */
    public $MassRate;
    /**
     * The InsrRate
     * @var int
     */
    public $InsrRate;
    /**
     * The AirRate
     * @var int
     */
    public $AirRate;
    /**
     * The Rate
     * @var int
     */
    public $Rate;
    /**
     * The CustomDuty
     * @var int
     */
    public $CustomDuty;
    /**
     * Constructor method for FinanceParameters
     * @uses FinanceParameters::setPayment()
     * @uses FinanceParameters::setValue()
     * @uses FinanceParameters::setMassRate()
     * @uses FinanceParameters::setInsrRate()
     * @uses FinanceParameters::setAirRate()
     * @uses FinanceParameters::setRate()
     * @uses FinanceParameters::setCustomDuty()
     * @param int $payment
     * @param int $value
     * @param int $massRate
     * @param int $insrRate
     * @param int $airRate
     * @param int $rate
     * @param int $customDuty
     */
    public function __construct($payment = null, $value = null, $massRate = null, $insrRate = null, $airRate = null, $rate = null, $customDuty = null)
    {
        $this
            ->setPayment($payment)
            ->setValue($value)
            ->setMassRate($massRate)
            ->setInsrRate($insrRate)
            ->setAirRate($airRate)
            ->setRate($rate)
            ->setCustomDuty($customDuty);
    }
    /**
     * Get Payment value
     * @return int|null
     */
    public function getPayment()
    {
        return $this->Payment;
    }
    /**
     * Set Payment value
     * @param int $payment
     * @return \StructType\FinanceParameters
     */
    public function setPayment($payment = null)
    {
        // validation for constraint: int
        if (!is_null($payment) && !is_numeric($payment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($payment)), __LINE__);
        }
        $this->Payment = $payment;
        return $this;
    }
    /**
     * Get Value value
     * @return int|null
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * Set Value value
     * @param int $value
     * @return \StructType\FinanceParameters
     */
    public function setValue($value = null)
    {
        // validation for constraint: int
        if (!is_null($value) && !is_numeric($value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($value)), __LINE__);
        }
        $this->Value = $value;
        return $this;
    }
    /**
     * Get MassRate value
     * @return int|null
     */
    public function getMassRate()
    {
        return $this->MassRate;
    }
    /**
     * Set MassRate value
     * @param int $massRate
     * @return \StructType\FinanceParameters
     */
    public function setMassRate($massRate = null)
    {
        // validation for constraint: int
        if (!is_null($massRate) && !is_numeric($massRate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($massRate)), __LINE__);
        }
        $this->MassRate = $massRate;
        return $this;
    }
    /**
     * Get InsrRate value
     * @return int|null
     */
    public function getInsrRate()
    {
        return $this->InsrRate;
    }
    /**
     * Set InsrRate value
     * @param int $insrRate
     * @return \StructType\FinanceParameters
     */
    public function setInsrRate($insrRate = null)
    {
        // validation for constraint: int
        if (!is_null($insrRate) && !is_numeric($insrRate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($insrRate)), __LINE__);
        }
        $this->InsrRate = $insrRate;
        return $this;
    }
    /**
     * Get AirRate value
     * @return int|null
     */
    public function getAirRate()
    {
        return $this->AirRate;
    }
    /**
     * Set AirRate value
     * @param int $airRate
     * @return \StructType\FinanceParameters
     */
    public function setAirRate($airRate = null)
    {
        // validation for constraint: int
        if (!is_null($airRate) && !is_numeric($airRate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($airRate)), __LINE__);
        }
        $this->AirRate = $airRate;
        return $this;
    }
    /**
     * Get Rate value
     * @return int|null
     */
    public function getRate()
    {
        return $this->Rate;
    }
    /**
     * Set Rate value
     * @param int $rate
     * @return \StructType\FinanceParameters
     */
    public function setRate($rate = null)
    {
        // validation for constraint: int
        if (!is_null($rate) && !is_numeric($rate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($rate)), __LINE__);
        }
        $this->Rate = $rate;
        return $this;
    }
    /**
     * Get CustomDuty value
     * @return int|null
     */
    public function getCustomDuty()
    {
        return $this->CustomDuty;
    }
    /**
     * Set CustomDuty value
     * @param int $customDuty
     * @return \StructType\FinanceParameters
     */
    public function setCustomDuty($customDuty = null)
    {
        // validation for constraint: int
        if (!is_null($customDuty) && !is_numeric($customDuty)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customDuty)), __LINE__);
        }
        $this->CustomDuty = $customDuty;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FinanceParameters
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
