<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddressParameters StructType
 * @subpackage Structs
 */
class AddressParameters extends AbstractStructBase
{
    /**
     * The DestinationAddress
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Address
     */
    public $DestinationAddress;
    /**
     * The OperationAddress
     * @var \StructType\Address
     */
    public $OperationAddress;
    /**
     * The MailDirect
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Country
     */
    public $MailDirect;
    /**
     * The CountryFrom
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Country
     */
    public $CountryFrom;
    /**
     * The CountryOper
     * @var \StructType\Country
     */
    public $CountryOper;
    /**
     * Constructor method for AddressParameters
     * @uses AddressParameters::setDestinationAddress()
     * @uses AddressParameters::setOperationAddress()
     * @uses AddressParameters::setMailDirect()
     * @uses AddressParameters::setCountryFrom()
     * @uses AddressParameters::setCountryOper()
     * @param \StructType\Address $destinationAddress
     * @param \StructType\Address $operationAddress
     * @param \StructType\Country $mailDirect
     * @param \StructType\Country $countryFrom
     * @param \StructType\Country $countryOper
     */
    public function __construct(\StructType\Address $destinationAddress = null, \StructType\Address $operationAddress = null, \StructType\Country $mailDirect = null, \StructType\Country $countryFrom = null, \StructType\Country $countryOper = null)
    {
        $this
            ->setDestinationAddress($destinationAddress)
            ->setOperationAddress($operationAddress)
            ->setMailDirect($mailDirect)
            ->setCountryFrom($countryFrom)
            ->setCountryOper($countryOper);
    }
    /**
     * Get DestinationAddress value
     * @return \StructType\Address|null
     */
    public function getDestinationAddress()
    {
        return $this->DestinationAddress;
    }
    /**
     * Set DestinationAddress value
     * @param \StructType\Address $destinationAddress
     * @return \StructType\AddressParameters
     */
    public function setDestinationAddress(\StructType\Address $destinationAddress = null)
    {
        $this->DestinationAddress = $destinationAddress;
        return $this;
    }
    /**
     * Get OperationAddress value
     * @return \StructType\Address|null
     */
    public function getOperationAddress()
    {
        return $this->OperationAddress;
    }
    /**
     * Set OperationAddress value
     * @param \StructType\Address $operationAddress
     * @return \StructType\AddressParameters
     */
    public function setOperationAddress(\StructType\Address $operationAddress = null)
    {
        $this->OperationAddress = $operationAddress;
        return $this;
    }
    /**
     * Get MailDirect value
     * @return \StructType\Country|null
     */
    public function getMailDirect()
    {
        return $this->MailDirect;
    }
    /**
     * Set MailDirect value
     * @param \StructType\Country $mailDirect
     * @return \StructType\AddressParameters
     */
    public function setMailDirect(\StructType\Country $mailDirect = null)
    {
        $this->MailDirect = $mailDirect;
        return $this;
    }
    /**
     * Get CountryFrom value
     * @return \StructType\Country|null
     */
    public function getCountryFrom()
    {
        return $this->CountryFrom;
    }
    /**
     * Set CountryFrom value
     * @param \StructType\Country $countryFrom
     * @return \StructType\AddressParameters
     */
    public function setCountryFrom(\StructType\Country $countryFrom = null)
    {
        $this->CountryFrom = $countryFrom;
        return $this;
    }
    /**
     * Get CountryOper value
     * @return \StructType\Country|null
     */
    public function getCountryOper()
    {
        return $this->CountryOper;
    }
    /**
     * Set CountryOper value
     * @param \StructType\Country $countryOper
     * @return \StructType\AddressParameters
     */
    public function setCountryOper(\StructType\Country $countryOper = null)
    {
        $this->CountryOper = $countryOper;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AddressParameters
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
