<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Postal ServiceType
 * @subpackage Services
 */
class Postal extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named PostalOrderEventsForMail
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PostalOrderEventsForMail $parameters
     * @return \StructType\PostalOrderEventsForMailResponse|bool
     */
    public function PostalOrderEventsForMail(\StructType\PostalOrderEventsForMail $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->PostalOrderEventsForMail($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\PostalOrderEventsForMailResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
